/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.collections;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class SelfCleaningValueTable<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentHashMap<K, ValueHolder<K, V>> _table = new ConcurrentHashMap();
    private final ReferenceQueue<V> _freeEntryQueue = new ReferenceQueue();
    private final Cleaner<K, V> _cleanerThread = new Cleaner<K, V>("SelfCleaningValueTable", this._freeEntryQueue, this._table);

    public SelfCleaningValueTable() {
        this._cleanerThread.setContextClassLoader(null);
        this._cleanerThread.start();
    }

    @Override
    public void clear() {
        this._table.clear();
    }

    @Override
    public V put(K key, V value) {
        return this.extractValue(this._table.put(key, this.createValueHolder(key, value)));
    }

    @Override
    public V get(Object key) {
        return this.extractValue(this._table.get(key));
    }

    private V extractValue(ValueHolder<K, V> holder) {
        return holder == null ? null : (V)holder.get();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._cleanerThread.interrupt();
        this._table.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._table.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._table.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this._table.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.extractValue(this._table.remove(key));
    }

    @Override
    public int size() {
        return this._table.size();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.extractValue(this._table.putIfAbsent(key, this.createValueHolder(key, value)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this._table.remove(key, this.createValueHolder(key, value));
    }

    @Override
    public V replace(K key, V value) {
        return this.extractValue(this._table.replace(key, this.createValueHolder(key, value)));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this._table.replace(key, this.createValueHolder(key, oldValue), this.createValueHolder(key, newValue));
    }

    private ValueHolder<K, V> createValueHolder(K key, V value) {
        return new ValueHolder<K, V>(key, value, this._freeEntryQueue);
    }

    private static class ValueHolder<K, T>
    extends WeakReference<T> {
        private final K _key;

        public ValueHolder(K key, T referent, ReferenceQueue<T> queue) {
            super(referent, queue);
            this._key = key;
        }

        public K getKey() {
            return this._key;
        }

        public boolean equals(Object o) {
            ValueHolder other = (ValueHolder)o;
            Object otherValue = other.get();
            Object value = this.get();
            return value != null && otherValue != null && value.equals(otherValue);
        }
    }

    private static final class Cleaner<K, V>
    extends GSThread {
        private final ReferenceQueue<V> _queue;
        private final Map<K, ValueHolder<K, V>> _table;

        public Cleaner(String parentName, ReferenceQueue<V> queue, Map<K, ValueHolder<K, V>> entryInfos) {
            super(parentName + "$Cleaner");
            this._queue = queue;
            this._table = entryInfos;
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    ValueHolder ref = (ValueHolder)this._queue.remove();
                    this._table.remove(ref.getKey());
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    break;
                }
            }
        }
    }
}

