/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.collections.economy;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.collections.economy.AbstractMap;
import com.gigaspaces.internal.utils.collections.economy.IEconomyConcurrentMap;
import com.gigaspaces.internal.utils.collections.economy.IHashEntry;
import com.gigaspaces.internal.utils.collections.economy.IHashEntryHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

@InternalApi
public class EconomyConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements IEconomyConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    final IHashEntryHandler<K, V> _handler;

    public static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public EconomyConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, IHashEntryHandler<K, V> handler) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        this._handler = handler;
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment<K, V>(cap, loadFactor, handler);
        }
    }

    public EconomyConcurrentHashMap(int initialCapacity, float loadFactor, IHashEntryHandler<K, V> handler) {
        this(initialCapacity, loadFactor, 16, handler);
    }

    public EconomyConcurrentHashMap(int initialCapacity, IHashEntryHandler<K, V> handler) {
        this(initialCapacity, 0.75f, 16, handler);
    }

    public EconomyConcurrentHashMap(IHashEntryHandler<K, V> handler) {
        this(16, 0.75f, 16, handler);
    }

    public EconomyConcurrentHashMap(Map<? extends K, ? extends V> m, IHashEntryHandler<K, V> handler) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16, handler);
        this.putAll(m);
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments.length; ++i) {
                segments[i].lock();
            }
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public V get(Object key) {
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        int i;
        if (value == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            boolean sum = false;
            int mcsum = 0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                int c = segments[i2].count;
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
                if (!segments[i2].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i3 = 0; i3 < segments.length; ++i3) {
                    int c = segments[i3].count;
                    if (mc[i3] == segments[i3].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (int i4 = 0; i4 < segments.length; ++i4) {
            segments[i4].lock();
        }
        boolean found = false;
        try {
            for (i = 0; i < segments.length; ++i) {
                if (!segments[i].containsValue(value)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        return found;
    }

    public void scan() {
        ScanResult sc = new ScanResult();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].scan(sc);
        }
        System.out.println("** scan result: overall:" + sc._scanned + " non-native=" + sc._nonNative + " native=" + sc._native);
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, value, false, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, value, true, false);
    }

    @Override
    public V putIfAbsent(K key, V value, boolean unstableKey) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, value, true, unstableKey);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void setKeyUnstable(K key) {
        int hash = EconomyConcurrentHashMap.hash(key.hashCode());
        this.segmentFor(hash).setKeyUnstable(key, hash);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int k = 0; k < this.segments.length; ++k) {
            Segment<K, V> seg = this.segments[k];
            seg.lock();
            try {
                IHashEntry<K, V>[] tab = seg.table;
                for (int i = 0; i < tab.length; ++i) {
                    IHashEntry e = tab[i];
                    while (e != null) {
                        s.writeObject(this._handler.key(e));
                        s.writeObject(this._handler.value(e));
                        e = this._handler.next(e);
                    }
                }
                continue;
            }
            finally {
                seg.unlock();
            }
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setTable(new IHashEntry[1]);
        }
        while (true) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = EconomyConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return EconomyConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return EconomyConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            EconomyConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EconomyConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return EconomyConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            EconomyConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return EconomyConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return EconomyConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return EconomyConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            EconomyConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            IHashEntry e = super.nextEntry();
            return new WriteThroughEntry(EconomyConcurrentHashMap.this._handler.key(e), EconomyConcurrentHashMap.this._handler.value(e));
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value);
            EconomyConcurrentHashMap.this.put(this.getKey(), value);
            return v;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return EconomyConcurrentHashMap.this._handler.value(super.nextEntry());
        }

        @Override
        public V nextElement() {
            return EconomyConcurrentHashMap.this._handler.value(super.nextEntry());
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return EconomyConcurrentHashMap.this._handler.key(super.nextEntry());
        }

        @Override
        public K nextElement() {
            return EconomyConcurrentHashMap.this._handler.key(super.nextEntry());
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        IHashEntry<K, V>[] currentTable;
        IHashEntry<K, V> nextEntry;
        IHashEntry<K, V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = EconomyConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = EconomyConcurrentHashMap.this._handler.next(this.nextEntry)) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = EconomyConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        IHashEntry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            EconomyConcurrentHashMap.this.remove(EconomyConcurrentHashMap.this._handler.key(this.lastReturned));
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient IHashEntry<K, V>[] table;
        final float loadFactor;
        final IHashEntryHandler<K, V> _h;

        Segment(int initialCapacity, float lf, IHashEntryHandler<K, V> h) {
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
            this._h = h;
        }

        static final <K, V> Segment<K, V>[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(IHashEntry<K, V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        IHashEntry<K, V> getFirst(int hash) {
            IHashEntry<K, V>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        V readValueUnderLock(IHashEntry<K, V> e) {
            this.lock();
            try {
                V v = this._h.value(e);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object key, int hash) {
            if (this.count != 0) {
                IHashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (this._h.hash(e) == hash && key.equals(this._h.key(e))) {
                        V v = this._h.value(e);
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = this._h.next(e);
                }
            }
            return null;
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                IHashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (this._h.hash(e) == hash && key.equals(this._h.key(e))) {
                        return true;
                    }
                    e = this._h.next(e);
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                for (IHashEntry<K, V> e : this.table) {
                    while (e != null) {
                        V v = this._h.value(e);
                        if (v == null) {
                            v = this.readValueUnderLock(e);
                        }
                        if (value.equals(v)) {
                            return true;
                        }
                        e = this._h.next(e);
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                IHashEntry<K, V> first;
                IHashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                IHashEntry<K, V> e = first = tab[index];
                while (!(e == null || this._h.hash(e) == hash && key.equals(this._h.key(e)))) {
                    e = this._h.next(e);
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(this._h.value(e))) {
                    replaced = true;
                    if (e.isNativeHashEntry()) {
                        ((HashEntry)e).value = newValue;
                    } else {
                        IHashEntry<K, V> newNode = this._h.createEntry(key, newValue, this._h.next(e), hash);
                        IHashEntry<K, V> a = first;
                        while (a != null && a != e) {
                            newNode = this._h.cloneEntry(a, newNode);
                            a = this._h.next(a);
                        }
                        tab[index] = newNode;
                    }
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newValue) {
            this.lock();
            try {
                IHashEntry<K, V> first;
                IHashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                IHashEntry<K, V> e = first = tab[index];
                while (!(e == null || this._h.hash(e) == hash && key.equals(this._h.key(e)))) {
                    e = this._h.next(e);
                }
                V oldValue = null;
                if (e != null) {
                    oldValue = this._h.value(e);
                    if (e.isNativeHashEntry()) {
                        ((HashEntry)e).value = newValue;
                    } else {
                        IHashEntry<K, V> newNode = this._h.createEntry(key, newValue, this._h.next(e), hash);
                        IHashEntry<K, V> a = first;
                        while (a != null && a != e) {
                            newNode = this._h.cloneEntry(a, newNode);
                            a = this._h.next(a);
                        }
                        tab[index] = newNode;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setKeyUnstable(K key, int hash) {
            this.lock();
            try {
                IHashEntry<K, V> first;
                IHashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                IHashEntry<K, V> e = first = tab[index];
                while (!(e == null || this._h.hash(e) == hash && key.equals(this._h.key(e)))) {
                    e = this._h.next(e);
                }
                boolean found = false;
                if (e != null) {
                    if (e.isNativeHashEntry() && ((HashEntry)e).isPinnedHashEntry()) {
                        return;
                    }
                    found = true;
                    IHashEntry<K, V> newNode = this._h.cloneEntry(e, this._h.next(e), true);
                    IHashEntry<K, V> a = first;
                    while (a != null && a != e) {
                        newNode = this._h.cloneEntry(a, newNode);
                        a = this._h.next(a);
                    }
                    tab[index] = newNode;
                }
                if (!found) {
                    throw new RuntimeException("setKeyUnstable: key not found " + key);
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent, boolean unstableKey) {
            if (!onlyIfAbsent) {
                throw new RuntimeException("Only put ifAbsent is supported");
            }
            this.lock();
            try {
                V oldValue;
                IHashEntry<K, V> first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                IHashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                IHashEntry<K, V> e = first = tab[index];
                while (!(e == null || this._h.hash(e) == hash && key.equals(this._h.key(e)))) {
                    e = this._h.next(e);
                }
                if (e != null) {
                    oldValue = this._h.value(e);
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = this._h.createEntry(key, value, first, hash, unstableKey);
                    this.count = c;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            IHashEntry<K, V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            IHashEntry<K, V>[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                IHashEntry<K, V> e = oldTable[i];
                if (e == null) continue;
                IHashEntry<K, V> next = this._h.next(e);
                int idx = this._h.hash(e) & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                IHashEntry<K, V> lastRun = e;
                int lastIdx = idx;
                IHashEntry<K, V> last = next;
                while (last != null) {
                    k = this._h.hash(last) & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = this._h.next(last);
                }
                newTable[lastIdx] = lastRun;
                IHashEntry<K, V> p = e;
                while (p != lastRun) {
                    k = this._h.hash(p) & sizeMask;
                    IHashEntry n = newTable[k];
                    newTable[k] = this._h.cloneEntry(p, n);
                    p = this._h.next(p);
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash, Object value) {
            this.lock();
            try {
                IHashEntry<K, V> first;
                int c = this.count - 1;
                IHashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                IHashEntry<K, V> e = first = tab[index];
                while (!(e == null || this._h.hash(e) == hash && key.equals(this._h.key(e)))) {
                    e = this._h.next(e);
                }
                V oldValue = null;
                if (e != null) {
                    V v = this._h.value(e);
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        IHashEntry<K, V> newFirst = this._h.next(e);
                        IHashEntry<K, V> p = first;
                        while (p != e) {
                            newFirst = this._h.cloneEntry(p, newFirst);
                            p = this._h.next(p);
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    IHashEntry<K, V>[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        void scan(ScanResult sc) {
            if (this.count != 0) {
                for (IHashEntry<K, V> e : this.table) {
                    while (e != null) {
                        ++sc._scanned;
                        if (e.isNativeHashEntry()) {
                            ++sc._native;
                        } else {
                            ++sc._nonNative;
                        }
                        e = this._h.next(e);
                    }
                }
            }
        }
    }

    private static class ScanResult {
        int _scanned;
        int _native;
        int _nonNative;

        ScanResult() {
        }
    }

    public static final class PinnedHashEntry<K, V>
    extends HashEntry<K, V> {
        public PinnedHashEntry(K key, int hash, IHashEntry<K, V> next, V value) {
            super(key, hash, next, value);
        }

        @Override
        public boolean isPinnedHashEntry() {
            return true;
        }
    }

    public static class HashEntry<K, V>
    implements IHashEntry<K, V> {
        final K key;
        final int hash;
        volatile V value;
        final IHashEntry<K, V> next;

        public HashEntry(K key, int hash, IHashEntry<K, V> next, V value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        @Override
        public int getHashCode(int id) {
            return this.hash;
        }

        @Override
        public K getKey(int id) {
            return this.key;
        }

        @Override
        public V getValue(int id) {
            return this.value;
        }

        @Override
        public boolean isNativeHashEntry() {
            return true;
        }

        public boolean isPinnedHashEntry() {
            return false;
        }

        static final <K, V> IHashEntry<K, V>[] newArray(int i) {
            return new IHashEntry[i];
        }
    }
}

