/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.collections.economy;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.collections.economy.EconomyConcurrentHashMap;
import com.gigaspaces.internal.utils.collections.economy.IHashEntry;
import com.gigaspaces.internal.utils.collections.economy.IHashEntryHandler;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.kernel.IStoredList;

@InternalApi
public class HashEntryHandlerSpaceEntry<K>
implements IHashEntryHandler<K, IStoredList<IEntryCacheInfo>> {
    private final int _keyIndicator;

    public HashEntryHandlerSpaceEntry(int keyIndicator) {
        this._keyIndicator = keyIndicator;
    }

    @Override
    public int hash(IHashEntry<K, IStoredList<IEntryCacheInfo>> e) {
        if (e.isNativeHashEntry()) {
            return ((EconomyConcurrentHashMap.HashEntry)e).hash;
        }
        return EconomyConcurrentHashMap.hash(e.getHashCode(this._keyIndicator));
    }

    @Override
    public K key(IHashEntry<K, IStoredList<IEntryCacheInfo>> e) {
        return e.getKey(this._keyIndicator);
    }

    @Override
    public IStoredList<IEntryCacheInfo> value(IHashEntry<K, IStoredList<IEntryCacheInfo>> e) {
        if (e.isNativeHashEntry()) {
            return (IStoredList)((EconomyConcurrentHashMap.HashEntry)e).value;
        }
        return (IStoredList)e;
    }

    @Override
    public IHashEntry<K, IStoredList<IEntryCacheInfo>> next(IHashEntry<K, IStoredList<IEntryCacheInfo>> e) {
        if (e.isNativeHashEntry()) {
            return ((EconomyConcurrentHashMap.HashEntry)e).next;
        }
        return null;
    }

    @Override
    public IHashEntry<K, IStoredList<IEntryCacheInfo>> createEntry(K key, IStoredList<IEntryCacheInfo> value, IHashEntry<K, IStoredList<IEntryCacheInfo>> next, int hash) {
        return this.createEntry(key, value, next, hash, false);
    }

    @Override
    public IHashEntry<K, IStoredList<IEntryCacheInfo>> createEntry(K key, IStoredList<IEntryCacheInfo> value, IHashEntry<K, IStoredList<IEntryCacheInfo>> next, int hash, boolean unstableKey) {
        if (next == null && !unstableKey) {
            return value;
        }
        return unstableKey ? new EconomyConcurrentHashMap.PinnedHashEntry<K, IStoredList<IEntryCacheInfo>>(key, hash, next, value) : new EconomyConcurrentHashMap.HashEntry<K, IStoredList<IEntryCacheInfo>>(key, hash, next, value);
    }

    @Override
    public IHashEntry<K, IStoredList<IEntryCacheInfo>> cloneEntry(IHashEntry<K, IStoredList<IEntryCacheInfo>> e, IHashEntry<K, IStoredList<IEntryCacheInfo>> newNext) {
        return this.cloneEntry(e, newNext, false);
    }

    @Override
    public IHashEntry<K, IStoredList<IEntryCacheInfo>> cloneEntry(IHashEntry<K, IStoredList<IEntryCacheInfo>> e, IHashEntry<K, IStoredList<IEntryCacheInfo>> newNext, boolean unstableKey) {
        int hash = e.getHashCode(this._keyIndicator);
        if (e.isNativeHashEntry()) {
            unstableKey = unstableKey || ((EconomyConcurrentHashMap.HashEntry)e).isPinnedHashEntry();
        } else if (newNext != null || unstableKey) {
            hash = EconomyConcurrentHashMap.hash(hash);
        }
        if (newNext == null && !unstableKey) {
            return e.getValue(this._keyIndicator);
        }
        return unstableKey ? new EconomyConcurrentHashMap.PinnedHashEntry<K, IStoredList<IEntryCacheInfo>>(e.getKey(this._keyIndicator), hash, newNext, e.getValue(this._keyIndicator)) : new EconomyConcurrentHashMap.HashEntry<K, IStoredList<IEntryCacheInfo>>(e.getKey(this._keyIndicator), hash, newNext, e.getValue(this._keyIndicator));
    }
}

