/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProviderStateListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAsyncHandlerProvider
implements IAsyncHandlerProvider {
    protected final Object _stateLock = new Object();
    private final Set<IAsyncHandlerProviderStateListener> _listeners = new HashSet<IAsyncHandlerProviderStateListener>();
    private volatile boolean _closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsyncHandler start(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
        if (idleDelayMilis == 0L) {
            throw new IllegalArgumentException("Cannot start async callable with idle delay of 0 ms, callable type - " + callable + ", callable name - " + name);
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this.isClosed()) {
                return ClosedProviderAsyncHandler.INSTANCE;
            }
            return this.startImpl(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
        }
    }

    protected abstract IAsyncHandler startImpl(AsyncCallable var1, long var2, String var4, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsyncHandler startMayBlock(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
        if (idleDelayMilis == 0L) {
            throw new IllegalArgumentException("Cannot start async callable with idle delay of 0 ms, callable type - " + callable + ", callable name - " + name);
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this.isClosed()) {
                return ClosedProviderAsyncHandler.INSTANCE;
            }
            return this.startMayBlockImpl(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
        }
    }

    protected abstract IAsyncHandler startMayBlockImpl(AsyncCallable var1, long var2, String var4, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Iterator<IAsyncHandlerProviderStateListener> iterator = this._stateLock;
        synchronized (iterator) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this.onClose();
        }
        for (IAsyncHandlerProviderStateListener listener : this._listeners) {
            listener.onClosed();
        }
        this._listeners.clear();
    }

    protected abstract void onClose();

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addStateListener(IAsyncHandlerProviderStateListener listener) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._closed) {
                return false;
            }
            this._listeners.add(listener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(IAsyncHandlerProviderStateListener listener) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._listeners.remove(listener);
        }
    }

    public static class ClosedProviderAsyncHandler
    implements IAsyncHandler {
        public static final ClosedProviderAsyncHandler INSTANCE = new ClosedProviderAsyncHandler();

        @Override
        public void wakeUp() {
        }

        @Override
        public boolean wakeUpAndWait(long timeout, TimeUnit units) {
            return false;
        }

        @Override
        public void stop(long timeout, TimeUnit units) {
        }

        @Override
        public void resume() {
        }

        @Override
        public void resumeNow() {
        }

        @Override
        public boolean isTerminated() {
            return true;
        }
    }
}

