/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.CompetitiveTask;
import com.gigaspaces.internal.utils.concurrent.ExchangeCountDownLatch;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProviderStateListener;
import com.j_spaces.core.exception.ClosedResourceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class CompetitionExecutor<T extends CompetitiveTask>
implements IAsyncHandlerProviderStateListener {
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final ExchangeCountDownLatch<T> _completionLatch;
    private final Object _lock;
    private int _pendingCompetitors;
    private volatile Throwable _error;

    protected CompetitionExecutor(IAsyncHandlerProvider asyncHandlerProvider) {
        this._asyncHandlerProvider = asyncHandlerProvider;
        this._completionLatch = new ExchangeCountDownLatch();
        this._lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(T[] competitors, long idleDelay, String name) {
        Object object = this._lock;
        synchronized (object) {
            this._pendingCompetitors = competitors.length;
        }
        for (int i = 0; i < competitors.length; ++i) {
            this._asyncHandlerProvider.start(this.wrapCompetitor(competitors[i]), idleDelay, name + "-competitor_" + i + "_of_" + competitors.length, false);
        }
        if (!this._asyncHandlerProvider.addStateListener(this)) {
            this.onClosed();
        }
    }

    protected abstract CompetitorWrapper wrapCompetitor(T var1);

    @Override
    public void onClosed() {
        this.onCompletion(null, new ClosedResourceException("Underlying resources are being closed"));
    }

    public boolean isCompleted() {
        return this._completionLatch.getCount() == 0L;
    }

    public T await(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        if (!this._completionLatch.await(timeout, unit)) {
            this.close();
            return null;
        }
        if (this._error != null) {
            throw new ExecutionException(this._error);
        }
        return (T)((CompetitiveTask)this._completionLatch.get());
    }

    private void close() {
        this._asyncHandlerProvider.removeStateListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletion(T competitor, Throwable error) {
        boolean isCompleted = false;
        Object object = this._lock;
        synchronized (object) {
            if (this.isCompleted()) {
                return;
            }
            if (competitor != null || error != null || --this._pendingCompetitors <= 0) {
                this._error = error;
                this._completionLatch.countDown(competitor);
                isCompleted = true;
            }
        }
        if (isCompleted) {
            this.close();
        }
    }

    protected static abstract class CompetitorWrapper
    extends AsyncCallable {
        private final T _competitor;
        final /* synthetic */ CompetitionExecutor this$0;

        protected CompetitorWrapper(T competitor) {
            this.this$0 = this$0;
            this._competitor = competitor;
        }

        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            if (this.this$0.isCompleted()) {
                return IAsyncHandlerProvider.CycleResult.TERMINATE;
            }
            try {
                boolean lastIteration = this.isLastIteration();
                if (this._competitor.execute(lastIteration)) {
                    this.this$0.onCompletion(this._competitor, null);
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                if (lastIteration) {
                    this.this$0.onCompletion(null, null);
                    return IAsyncHandlerProvider.CycleResult.TERMINATE;
                }
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
            catch (Throwable e) {
                this.this$0.onCompletion(null, e);
                return IAsyncHandlerProvider.CycleResult.TERMINATE;
            }
        }

        protected abstract boolean isLastIteration();
    }
}

