/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import java.util.concurrent.Callable;

public abstract class ContextClassLoaderCallable<T>
implements Callable<T> {
    private final ClassLoader _contextClassLoader;

    public ContextClassLoaderCallable() {
        this._contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public ContextClassLoaderCallable(ClassLoader contextClassLoader) {
        this._contextClassLoader = contextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        boolean wasChanged;
        Thread executionThread = Thread.currentThread();
        ClassLoader executionClassLoader = executionThread.getContextClassLoader();
        boolean bl = wasChanged = executionClassLoader != this._contextClassLoader;
        if (wasChanged) {
            executionThread.setContextClassLoader(this._contextClassLoader);
        }
        try {
            T t = this.execute();
            return t;
        }
        finally {
            if (wasChanged) {
                executionThread.setContextClassLoader(executionClassLoader);
            }
        }
    }

    protected abstract T execute() throws Exception;
}

