/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class CyclicAtomicInteger {
    private final AtomicInteger _value;
    private final int maxValue;

    public CyclicAtomicInteger(int maxValue) {
        this.maxValue = maxValue;
        this._value = new AtomicInteger();
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public final int get() {
        return this._value.get();
    }

    public final int incrementAndGet() {
        int next;
        int current;
        while (!this._value.compareAndSet(current, next = (current = this._value.get()) == this.maxValue ? 0 : current + 1)) {
        }
        return next;
    }

    public final int getAndIncrement() {
        int next;
        int current;
        while (!this._value.compareAndSet(current, next = (current = this._value.get()) == this.maxValue ? 0 : current + 1)) {
        }
        return current;
    }
}

