/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InternalApi
public class ExchangeCountDownLatch<T>
extends CountDownLatch {
    private volatile T _obj;

    public ExchangeCountDownLatch() {
        super(1);
    }

    public ExchangeCountDownLatch(int count) {
        super(count);
    }

    public void exchange(T obj) {
        this._obj = obj;
    }

    public void countDown(T obj) {
        this._obj = obj;
        this.countDown();
    }

    public T get() {
        return this._obj;
    }

    public T waitForResult() throws InterruptedException {
        super.await();
        return this._obj;
    }

    public T waitForResult(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (super.await(timeout, unit)) {
            return this._obj;
        }
        throw new TimeoutException("Operation timed out after " + timeout + " " + unit.name().toLowerCase());
    }
}

