/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.ISimpleLock;

@InternalApi
public class NonReentrantSimpleLock
implements ISimpleLock {
    private Thread _owningThread;
    private int _waiters;

    @Override
    public synchronized boolean tryLock() {
        if (this._owningThread != null) {
            return false;
        }
        this._owningThread = Thread.currentThread();
        return true;
    }

    @Override
    public synchronized void lock() {
        ++this._waiters;
        boolean wasInterrupted = false;
        while (this._owningThread != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        this._owningThread = Thread.currentThread();
        --this._waiters;
    }

    @Override
    public synchronized void unlock() {
        Thread currentThread = Thread.currentThread();
        if (this._owningThread != currentThread) {
            throw new IllegalMonitorStateException(currentThread + " does not hold the lock");
        }
        this._owningThread = null;
        if (this._waiters > 0) {
            this.notify();
        }
    }
}

