/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.ISimpleLock;

@InternalApi
public class ReentrantSimpleLock
implements ISimpleLock {
    private Thread _owningThread;
    private int _lockCount;
    private int _waiters;

    @Override
    public synchronized boolean tryLock() {
        Thread currentThread = Thread.currentThread();
        if (this._owningThread != null && this._owningThread != currentThread) {
            return false;
        }
        ++this._lockCount;
        this._owningThread = currentThread;
        return true;
    }

    @Override
    public synchronized void lock() {
        ++this._waiters;
        Thread currentThread = Thread.currentThread();
        boolean wasInterrupted = false;
        while (this._owningThread != null && this._owningThread != currentThread) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        ++this._lockCount;
        this._owningThread = currentThread;
        --this._waiters;
    }

    @Override
    public synchronized void unlock() {
        Thread currentThread = Thread.currentThread();
        if (this._owningThread != currentThread) {
            throw new IllegalMonitorStateException(currentThread + " does not hold the lock");
        }
        if (--this._lockCount == 0) {
            this._owningThread = null;
            if (this._waiters > 0) {
                this.notify();
            }
        }
    }
}

