/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.CompetitionExecutor;
import com.gigaspaces.internal.utils.concurrent.CompetitiveTask;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;

@InternalApi
public class RepeatsCompetitionExecutor<T extends CompetitiveTask>
extends CompetitionExecutor<T> {
    private final int _maxRepeats;

    public RepeatsCompetitionExecutor(T[] competitors, int maxRepeats, String name, IAsyncHandlerProvider asyncHandlerProvider, long idleDelay) {
        super(asyncHandlerProvider);
        if (maxRepeats <= 0) {
            throw new IllegalArgumentException("maxRepeats must be positive: " + maxRepeats);
        }
        this._maxRepeats = maxRepeats;
        this.start((CompetitiveTask[])competitors, idleDelay, name);
    }

    @Override
    protected CompetitionExecutor.CompetitorWrapper wrapCompetitor(T competitor) {
        return new RepeatsCompetitorWrapper(this, competitor);
    }

    private static class RepeatsCompetitorWrapper
    extends CompetitionExecutor.CompetitorWrapper {
        private int _repeats;
        final /* synthetic */ RepeatsCompetitionExecutor this$0;

        public RepeatsCompetitorWrapper(T competitor) {
            this.this$0 = var1_1;
            super((CompetitionExecutor)var1_1, competitor);
        }

        @Override
        protected boolean isLastIteration() {
            return ++this._repeats >= this.this$0._maxRepeats;
        }
    }
}

