/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;

@InternalApi
public class RunnableContextClassLoaderDecorator
implements Runnable {
    private final ClassLoader executingClassLoader;
    private final Runnable command;

    public RunnableContextClassLoaderDecorator(ClassLoader executingClassLoader, Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        this.executingClassLoader = executingClassLoader;
        this.command = command;
    }

    @Override
    public void run() {
        Thread t = Thread.currentThread();
        ClassLoader current = t.getContextClassLoader();
        t.setContextClassLoader(this.executingClassLoader);
        try {
            this.command.run();
        }
        finally {
            t.setContextClassLoader(current);
        }
    }
}

