/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.AbstractAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.ThreadAsyncHandlerProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ScheduledThreadPoolAsyncHandlerProvider
extends AbstractAsyncHandlerProvider {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication");
    private final ScheduledExecutorService _executorService;
    private final ThreadAsyncHandlerProvider _threadAsyncHandlerProvider = new ThreadAsyncHandlerProvider();

    public ScheduledThreadPoolAsyncHandlerProvider(String name, int corePoolSize) {
        this._executorService = Executors.newScheduledThreadPool(corePoolSize, (ThreadFactory)new GSThreadFactory(name, true));
    }

    @Override
    public IAsyncHandler startImpl(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
        AsyncRunnableWrapper wrapper = new AsyncRunnableWrapper(callable, idleDelayMilis, name);
        callable.setHandler(wrapper);
        wrapper.start(waitIdleDelayBeforeStart);
        return wrapper;
    }

    @Override
    public IAsyncHandler startMayBlockImpl(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
        return this._threadAsyncHandlerProvider.startMayBlock(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
    }

    @Override
    protected void onClose() {
        this._executorService.shutdownNow();
        this._threadAsyncHandlerProvider.close();
    }

    private class AsyncRunnableWrapper
    implements IAsyncHandler {
        private final Callable<IAsyncHandlerProvider.CycleResult> _runnable;
        private final long _idleDelayMilis;
        private final String _name;
        private final Lock _lock = new ReentrantLock(true);
        private final Condition _condition;
        private final AtomicBoolean _singleRunnerFlag = new AtomicBoolean(false);
        private Future<?> _future;
        private int _iteration;
        private volatile State _state;
        private IAsyncHandlerProvider.CycleResult _pendingSuspendedResponse;

        public AsyncRunnableWrapper(Callable<IAsyncHandlerProvider.CycleResult> runnable, long idleDelayMilis, String name) {
            this._runnable = runnable;
            this._idleDelayMilis = idleDelayMilis;
            this._name = name;
            this._condition = this._lock.newCondition();
        }

        public void start(boolean waitIdleDelayBeforeStart) {
            this._lock.lock();
            try {
                if (waitIdleDelayBeforeStart) {
                    this.reschedule();
                } else {
                    this.resubmit();
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void wakeUp() {
            this._lock.lock();
            try {
                switch (this._state) {
                    case STOPPED: 
                    case SUBMITTED: 
                    case RUNNING: 
                    case SUSPENDED: {
                        return;
                    }
                    case SCHEDULED: {
                        if (!this._future.cancel(false)) return;
                        this.resubmit();
                        return;
                    }
                    default: {
                        throw new IllegalStateException("unknown state " + (Object)((Object)this._state));
                    }
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        private void resubmit() {
            block3: {
                try {
                    if (this.changeState(State.SUBMITTED)) {
                        this._future = ScheduledThreadPoolAsyncHandlerProvider.this._executorService.submit(this.createExecutionTask());
                    }
                }
                catch (RejectedExecutionException e) {
                    if (ScheduledThreadPoolAsyncHandlerProvider.this.isClosed()) break block3;
                    throw e;
                }
            }
        }

        private void reschedule() {
            block3: {
                try {
                    if (this.changeState(State.SCHEDULED)) {
                        this._future = ScheduledThreadPoolAsyncHandlerProvider.this._executorService.schedule(this.createExecutionTask(), this._idleDelayMilis, TimeUnit.MILLISECONDS);
                    }
                }
                catch (RejectedExecutionException e) {
                    if (ScheduledThreadPoolAsyncHandlerProvider.this.isClosed()) break block3;
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean wakeUpAndWait(long timeout, TimeUnit units) {
            this._lock.lock();
            try {
                if (this._state == State.STOPPED) {
                    boolean bl = false;
                    return bl;
                }
                int startIteration = this._iteration;
                this.wakeUp();
                while (startIteration == this._iteration) {
                    try {
                        if (this._condition.await(timeout, units)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop(long timeout, TimeUnit units) {
            if (this._state == State.STOPPED) {
                return;
            }
            this._lock.lock();
            try {
                if (this._state == State.STOPPED) {
                    return;
                }
                while (this._state == State.RUNNING && this._condition.await(timeout, units)) {
                }
                if (!this.changeState(State.STOPPED)) {
                    return;
                }
                if (this._future != null) {
                    this._future.cancel(true);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public void resume() {
            this._lock.lock();
            try {
                if (this._state == State.RUNNING) {
                    this._pendingSuspendedResponse = IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                    return;
                }
                if (this._state != State.SUSPENDED) {
                    return;
                }
                this.reschedule();
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public void resumeNow() {
            this._lock.lock();
            try {
                if (this._state == State.RUNNING) {
                    this._pendingSuspendedResponse = IAsyncHandlerProvider.CycleResult.CONTINUE;
                    return;
                }
                if (this._state != State.SUSPENDED) {
                    return;
                }
                this.resubmit();
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public boolean isTerminated() {
            if (ScheduledThreadPoolAsyncHandlerProvider.this.isClosed()) {
                return true;
            }
            return this._state == State.STOPPED;
        }

        private Runnable createExecutionTask() {
            return new ExecutionTask(this._iteration);
        }

        private boolean changeState(State state) {
            if (this._state == State.STOPPED) {
                return false;
            }
            this._state = state;
            return true;
        }

        private class ExecutionTask
        implements Runnable {
            private final int _iterationAtGeneration;

            public ExecutionTask(int iteration) {
                this._iterationAtGeneration = iteration;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    AsyncRunnableWrapper.this._lock.lock();
                    try {
                        if (AsyncRunnableWrapper.this._iteration != this._iterationAtGeneration) return;
                        if (!AsyncRunnableWrapper.this.changeState(State.RUNNING)) {
                            return;
                        }
                    }
                    finally {
                        AsyncRunnableWrapper.this._lock.unlock();
                    }
                    if (!AsyncRunnableWrapper.this._singleRunnerFlag.compareAndSet(false, true)) {
                        return;
                    }
                    IAsyncHandlerProvider.CycleResult cycleResult = (IAsyncHandlerProvider.CycleResult)((Object)AsyncRunnableWrapper.this._runnable.call());
                    AsyncRunnableWrapper.this._lock.lock();
                    try {
                        if (AsyncRunnableWrapper.this._state == State.STOPPED) {
                            return;
                        }
                        if (cycleResult == IAsyncHandlerProvider.CycleResult.SUSPEND && AsyncRunnableWrapper.this._pendingSuspendedResponse != null) {
                            cycleResult = AsyncRunnableWrapper.this._pendingSuspendedResponse;
                        }
                        AsyncRunnableWrapper.this._pendingSuspendedResponse = null;
                        AsyncRunnableWrapper.this._iteration++;
                        AsyncRunnableWrapper.this._condition.signalAll();
                        switch (cycleResult) {
                            case IDLE_CONTINUE: {
                                AsyncRunnableWrapper.this.reschedule();
                                return;
                            }
                            case CONTINUE: {
                                AsyncRunnableWrapper.this.resubmit();
                                return;
                            }
                            case SUSPEND: {
                                AsyncRunnableWrapper.this.changeState(State.SUSPENDED);
                                return;
                            }
                            case TERMINATE: {
                                AsyncRunnableWrapper.this.changeState(State.STOPPED);
                                return;
                            }
                        }
                        return;
                    }
                    finally {
                        if (!AsyncRunnableWrapper.this._singleRunnerFlag.compareAndSet(true, false) && _logger.isLoggable(Level.SEVERE)) {
                            _logger.severe("Unexpected single flag runner result on ScheduledThreadPoolAsyncHandlerProvider. task is " + AsyncRunnableWrapper.this._runnable);
                        }
                        AsyncRunnableWrapper.this._lock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (!_logger.isLoggable(Level.FINER)) return;
                    _logger.log(Level.FINER, "async handler is interrupted", e);
                    return;
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) return;
                    _logger.log(Level.SEVERE, "Error occurred while executing async cycle", e);
                }
            }
        }
    }

    private static enum State {
        STOPPED,
        SCHEDULED,
        SUBMITTED,
        RUNNING,
        SUSPENDED;

    }
}

