/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class SegmentedAtomicInteger
extends Number {
    private static final long serialVersionUID = 431083030353672207L;
    private final AtomicInteger[] counters;
    private final int _initialValue;

    public SegmentedAtomicInteger() {
        this(0);
    }

    public SegmentedAtomicInteger(int initialValue) {
        this(initialValue, 13);
    }

    public SegmentedAtomicInteger(int initialValue, int concurrencyLevel) {
        this._initialValue = initialValue;
        this.counters = new AtomicInteger[concurrencyLevel];
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new AtomicInteger();
        }
        this.counters[0].set(initialValue);
    }

    public void decrement() {
        this.getCounter().decrementAndGet();
    }

    public void increment() {
        this.getCounter().incrementAndGet();
    }

    public void add(int delta) {
        this.getCounter().addAndGet(delta);
    }

    public int decrementAndGet() {
        this.decrement();
        return this.get();
    }

    public int incrementAndGet() {
        this.increment();
        return this.get();
    }

    public int addAndGet(int delta) {
        this.add(delta);
        return this.get();
    }

    public int get() {
        int size = 0;
        for (AtomicInteger counter : this.counters) {
            size += counter.get();
        }
        return size;
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    public void reset() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i].set(0);
        }
        this.counters[0].set(this._initialValue);
    }

    private AtomicInteger getCounter() {
        int index = (int)Thread.currentThread().getId() % this.counters.length;
        return this.counters[index];
    }
}

