/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@InternalApi
public class SegmentedReentrantReadWriteLock {
    private final int _numOfSegments;
    private final ReadWriteLock[] _locks;
    private final Lock[] _readLocks;
    private final Lock[] _writeLocks;

    public SegmentedReentrantReadWriteLock(int numOfSegments, boolean fair) {
        if (numOfSegments < 1) {
            throw new IllegalArgumentException("Illegal argument 'numOfSegments' - cannot be less than 1.");
        }
        this._numOfSegments = numOfSegments;
        this._locks = new ReadWriteLock[numOfSegments];
        this._readLocks = new Lock[numOfSegments];
        this._writeLocks = new Lock[numOfSegments];
        for (int i = 0; i < numOfSegments; ++i) {
            this._locks[i] = new ReentrantReadWriteLock(fair);
            this._readLocks[i] = this._locks[i].readLock();
            this._writeLocks[i] = this._locks[i].writeLock();
        }
    }

    public void acquireWriteLock() {
        for (int i = 0; i < this._numOfSegments; ++i) {
            this._writeLocks[i].lock();
        }
    }

    public void releaseWriteLock() {
        for (int i = 0; i < this._numOfSegments; ++i) {
            this._writeLocks[i].unlock();
        }
    }

    public void acquireReadLock(int segmentId) {
        this._readLocks[segmentId].lock();
    }

    public void releaseReadLock(int segmentId) {
        this._readLocks[segmentId].unlock();
    }

    public int getSegmentIdByCurrentThreadId() {
        return (int)(Thread.currentThread().getId() % (long)this._numOfSegments);
    }

    public void acquireThreadReadLock() {
        this._readLocks[this.getSegmentIdByCurrentThreadId()].lock();
    }

    public void releaseThreadReadLock() {
        this._readLocks[this.getSegmentIdByCurrentThreadId()].unlock();
    }
}

