/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.utils.concurrent.AbstractAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.ScheduledThreadPoolAsyncHandlerProvider;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@InternalApi
public class SharedHandlerProviderCache
implements IClassLoaderCacheStateListener {
    private static final SharedHandlerProviderCache INSTANCE_SHARED_POOL = new SharedHandlerProviderCache(new IAsyncHandlerProviderFactory(){
        private final int corePoolSize = Runtime.getRuntime().availableProcessors();

        @Override
        public IAsyncHandlerProvider createProvider(String name) {
            return new ScheduledThreadPoolAsyncHandlerProvider("SharedScheduledPoolAsyncHandlerProvider-" + name, this.corePoolSize);
        }
    });
    private final Map<Long, SharedAsyncHandlerProvider> _cachedAsyncHandlers = new HashMap<Long, SharedAsyncHandlerProvider>();
    private final IAsyncHandlerProviderFactory _factory;
    private final Object _lock = new Object();

    public static SharedHandlerProviderCache getSharedThreadPoolProviderCache() {
        return INSTANCE_SHARED_POOL;
    }

    private SharedHandlerProviderCache(IAsyncHandlerProviderFactory factory) {
        this._factory = factory;
        ClassLoaderCache.getCache().registerCacheStateListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAsyncHandlerProvider getProvider() {
        Object object = this._lock;
        synchronized (object) {
            SharedAsyncHandlerProvider handlerProvider;
            ClassLoader contextClassLoader = ClassLoaderHelper.getContextClassLoader();
            Long classLoaderKey = null;
            if (contextClassLoader != null) {
                classLoaderKey = ClassLoaderCache.getCache().putClassLoader(contextClassLoader);
            }
            if ((handlerProvider = this._cachedAsyncHandlers.get(classLoaderKey)) == null) {
                handlerProvider = this.createNewHandlerProvider(ClassLoaderHelper.getClassLoaderLogName(contextClassLoader), classLoaderKey);
                this._cachedAsyncHandlers.put(classLoaderKey, handlerProvider);
            } else {
                handlerProvider.addReference();
            }
            return handlerProvider.getWrapper();
        }
    }

    private SharedAsyncHandlerProvider createNewHandlerProvider(String name, Long classLoaderKey) {
        IAsyncHandlerProvider asyncHandlerProvider = this._factory.createProvider(name);
        return new SharedAsyncHandlerProvider(asyncHandlerProvider, classLoaderKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
        Object object = this._lock;
        synchronized (object) {
            SharedAsyncHandlerProvider sharedAsyncHandlerProvider = this._cachedAsyncHandlers.remove(classLoaderKey);
            if (sharedAsyncHandlerProvider != null) {
                IAsyncHandlerProvider asyncHandlerProvider = sharedAsyncHandlerProvider.getUnderlyingHandler();
                asyncHandlerProvider.close();
            }
        }
    }

    public static interface IAsyncHandlerProviderFactory {
        public IAsyncHandlerProvider createProvider(String var1);
    }

    public static class SharedAsyncHandlerProviderWrapper
    extends AbstractAsyncHandlerProvider {
        private final SharedAsyncHandlerProvider _sharedAsyncHandlerProvider;
        private final List<IAsyncHandler> _handlers = new LinkedList<IAsyncHandler>();

        public SharedAsyncHandlerProviderWrapper(SharedAsyncHandlerProvider sharedAsyncHandlerProvider) {
            this._sharedAsyncHandlerProvider = sharedAsyncHandlerProvider;
        }

        @Override
        public IAsyncHandler startImpl(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
            IAsyncHandler asyncHandler = this._sharedAsyncHandlerProvider.start(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
            this._handlers.add(asyncHandler);
            return asyncHandler;
        }

        @Override
        public IAsyncHandler startMayBlockImpl(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
            IAsyncHandler asyncHandler = this._sharedAsyncHandlerProvider.startMayBlock(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
            this._handlers.add(asyncHandler);
            return asyncHandler;
        }

        @Override
        protected void onClose() {
            for (IAsyncHandler handler : this._handlers) {
                handler.stop(10L, TimeUnit.MILLISECONDS);
            }
            this._handlers.clear();
            this._sharedAsyncHandlerProvider.close();
        }
    }

    private class SharedAsyncHandlerProvider {
        private final IAsyncHandlerProvider _asyncHandlerProvider;
        private int _referenceCounter = 1;
        private final Long _classLoaderKey;

        public SharedAsyncHandlerProvider(IAsyncHandlerProvider asyncHandlerProvider, Long classLoaderKey) {
            this._asyncHandlerProvider = asyncHandlerProvider;
            this._classLoaderKey = classLoaderKey;
        }

        public IAsyncHandlerProvider getWrapper() {
            return new SharedAsyncHandlerProviderWrapper(this);
        }

        public IAsyncHandlerProvider getUnderlyingHandler() {
            return this._asyncHandlerProvider;
        }

        public IAsyncHandler start(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
            return this._asyncHandlerProvider.start(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
        }

        public IAsyncHandler startMayBlock(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
            return this._asyncHandlerProvider.startMayBlock(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = SharedHandlerProviderCache.this._lock;
            synchronized (object) {
                if (--this._referenceCounter == 0) {
                    SharedHandlerProviderCache.this._cachedAsyncHandlers.remove(this._classLoaderKey);
                    this._asyncHandlerProvider.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addReference() {
            Object object = SharedHandlerProviderCache.this._lock;
            synchronized (object) {
                ++this._referenceCounter;
            }
        }
    }
}

