/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.AbstractAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ThreadAsyncHandlerProvider
extends AbstractAsyncHandlerProvider {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication");
    private final Set<Thread> _threads = new HashSet<Thread>();

    @Override
    public IAsyncHandler startImpl(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
        AsyncRunnableWrapper wrapper = new AsyncRunnableWrapper(this, callable, idleDelayMilis, waitIdleDelayBeforeStart);
        callable.setHandler(wrapper);
        GSThread thread = StringUtils.hasText(name) ? new GSThread((Runnable)wrapper, name) : new GSThread((Runnable)wrapper);
        thread.setDaemon(true);
        this._threads.add((Thread)thread);
        wrapper.setThread((Thread)thread);
        thread.start();
        return wrapper;
    }

    @Override
    public IAsyncHandler startMayBlockImpl(AsyncCallable callable, long idleDelayMilis, String name, boolean waitIdleDelayBeforeStart) {
        return this.startImpl(callable, idleDelayMilis, name, waitIdleDelayBeforeStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrent() {
        Object object = this._stateLock;
        synchronized (object) {
            this._threads.remove(Thread.currentThread());
        }
    }

    @Override
    protected void onClose() {
        for (Thread thread : this._threads) {
            thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeThreadsCount() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._threads.size();
        }
    }

    public static class AsyncRunnableWrapper
    implements Runnable,
    IAsyncHandler {
        private final Callable<IAsyncHandlerProvider.CycleResult> _runnable;
        private final ThreadAsyncHandlerProvider _provider;
        private final long _idleDelayMilis;
        private final Lock _lock = new ReentrantLock(false);
        private final Condition _condition;
        private final boolean _waitIdleDelayBeforeStart;
        private boolean _wakenUp;
        private int _cycle;
        private volatile boolean _stopped;
        private volatile Thread _thread;
        private volatile boolean _terminated;
        private boolean _resumeRequest;
        private boolean _resumeNowRequest;

        public AsyncRunnableWrapper(ThreadAsyncHandlerProvider provider, Callable<IAsyncHandlerProvider.CycleResult> runnable, long idleDelayMilis, boolean waitIdleDelayBeforeStart) {
            this._provider = provider;
            this._runnable = runnable;
            this._idleDelayMilis = idleDelayMilis;
            this._waitIdleDelayBeforeStart = waitIdleDelayBeforeStart;
            this._condition = this._lock.newCondition();
        }

        public void setThread(Thread thread) {
            this._thread = thread;
        }

        @Override
        public void run() {
            block17: {
                try {
                    IAsyncHandlerProvider.CycleResult cycleResult;
                    if (this._waitIdleDelayBeforeStart) {
                        this._lock.lock();
                        try {
                            this._condition.await(this._idleDelayMilis, TimeUnit.MILLISECONDS);
                            if (this._stopped) {
                                return;
                            }
                        }
                        finally {
                            this._lock.unlock();
                        }
                    }
                    do {
                        cycleResult = this._runnable.call();
                        this._lock.lock();
                        try {
                            ++this._cycle;
                            this._condition.signalAll();
                            if (cycleResult == IAsyncHandlerProvider.CycleResult.SUSPEND) {
                                while (!(this._stopped || this._resumeRequest || this._resumeNowRequest)) {
                                    this._condition.await();
                                }
                                if (!this._stopped) {
                                    IAsyncHandlerProvider.CycleResult cycleResult2 = cycleResult = this._resumeRequest ? IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE : IAsyncHandlerProvider.CycleResult.CONTINUE;
                                }
                            }
                            if (cycleResult == IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE && !this._wakenUp) {
                                this._condition.await(this._idleDelayMilis, TimeUnit.MILLISECONDS);
                            }
                            this._resumeRequest = false;
                            this._resumeNowRequest = false;
                            this._wakenUp = false;
                        }
                        finally {
                            this._lock.unlock();
                        }
                    } while (!this._stopped && cycleResult != IAsyncHandlerProvider.CycleResult.TERMINATE);
                    this._terminated = true;
                }
                catch (InterruptedException cycleResult) {
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block17;
                    _logger.log(Level.SEVERE, "Error occurred while executing async cycle", e);
                }
            }
            this._terminated = true;
            this._provider.removeCurrent();
        }

        @Override
        public void wakeUp() {
            this._lock.lock();
            try {
                this._wakenUp = true;
                this._condition.signalAll();
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean wakeUpAndWait(long timeout, TimeUnit units) {
            if (this._terminated || this._stopped) {
                return false;
            }
            this._lock.lock();
            try {
                int cycleBeforeWakeup = this._cycle;
                this.wakeUp();
                while (this._cycle == cycleBeforeWakeup) {
                    try {
                        if (this._condition.await(timeout, units)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public void stop(long timeout, TimeUnit units) {
            if (this._terminated || this._stopped) {
                return;
            }
            this._stopped = true;
            this.wakeUp();
            try {
                Thread thread = this._thread;
                if (thread != null) {
                    thread.join(units.toMillis(timeout));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void resume() {
            if (this._terminated || this._stopped) {
                return;
            }
            this._lock.lock();
            try {
                this._resumeRequest = true;
                this._condition.signalAll();
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public void resumeNow() {
            if (this._terminated || this._stopped) {
                return;
            }
            this._lock.lock();
            try {
                this._resumeNowRequest = true;
                this._condition.signalAll();
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public boolean isTerminated() {
            return this._terminated || this._stopped;
        }
    }
}

