/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.CompetitionExecutor;
import com.gigaspaces.internal.utils.concurrent.CompetitiveTask;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.time.SystemTime;

@InternalApi
public class TimedCompetitionExecutor<T extends CompetitiveTask>
extends CompetitionExecutor<T> {
    private final long _deadline;

    public TimedCompetitionExecutor(T[] competitors, long timeout, String name, IAsyncHandlerProvider asyncHandlerProvider, long idleDelay) {
        super(asyncHandlerProvider);
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be positive: " + timeout);
        }
        this._deadline = SystemTime.timeMillis() + timeout;
        this.start((CompetitiveTask[])competitors, idleDelay, name);
    }

    @Override
    protected CompetitionExecutor.CompetitorWrapper wrapCompetitor(T competitor) {
        return new TimedCompetitorWrapper(this, competitor);
    }

    private static class TimedCompetitorWrapper
    extends CompetitionExecutor.CompetitorWrapper {
        final /* synthetic */ TimedCompetitionExecutor this$0;

        public TimedCompetitorWrapper(T competitor) {
            this.this$0 = var1_1;
            super((CompetitionExecutor)var1_1, competitor);
        }

        @Override
        protected boolean isLastIteration() {
            long currTime = SystemTime.timeMillis();
            return currTime > this.this$0._deadline;
        }
    }
}

