/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.internal.utils.concurrent.UnsafeHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class UncheckedAtomicIntegerFieldUpdater<T> {
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> tclass, String fieldName) {
        if (UnsafeHolder.isAvailable()) {
            return new AtomicIntegerFieldUpdaterImpl<U>(tclass, fieldName);
        }
        return AtomicIntegerFieldUpdater.newUpdater(tclass, fieldName);
    }

    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private final long offset;

        AtomicIntegerFieldUpdaterImpl(Class<T> tclass, String fieldName) {
            Field field = null;
            int modifiers = 0;
            try {
                field = tclass.getDeclaredField(fieldName);
                modifiers = field.getModifiers();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Class<?> fieldt = field.getType();
            if (fieldt != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.offset = UnsafeHolder.objectFieldOffset(field);
        }

        @Override
        public boolean compareAndSet(T obj, int expect, int update) {
            return UnsafeHolder.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, int expect, int update) {
            return UnsafeHolder.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, int newValue) {
            UnsafeHolder.putIntVolatile(obj, this.offset, newValue);
        }

        @Override
        public final int get(T obj) {
            return UnsafeHolder.getIntVolatile(obj, this.offset);
        }

        @Override
        public void lazySet(T obj, int newValue) {
            throw new UnsupportedOperationException();
        }
    }
}

