/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.internal.utils.concurrent.UnsafeHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class UncheckedAtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> tclass, Class<W> vclass, String fieldName) {
        if (UnsafeHolder.isAvailable()) {
            return new AtomicReferenceFieldUpdaterImpl<U, W>(tclass, vclass, fieldName);
        }
        return AtomicReferenceFieldUpdater.newUpdater(tclass, vclass, fieldName);
    }

    private static class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private final long offset;

        AtomicReferenceFieldUpdaterImpl(Class<T> tclass, Class<V> vclass, String fieldName) {
            Field field = null;
            Class<?> fieldClass = null;
            int modifiers = 0;
            try {
                field = tclass.getDeclaredField(fieldName);
                modifiers = field.getModifiers();
                fieldClass = field.getType();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (vclass != fieldClass) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.offset = UnsafeHolder.objectFieldOffset(field);
        }

        @Override
        public boolean compareAndSet(T obj, V expect, V update) {
            return UnsafeHolder.compareAndSwapObject(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, V expect, V update) {
            return UnsafeHolder.compareAndSwapObject(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, V newValue) {
            UnsafeHolder.putObjectVolatile(obj, this.offset, newValue);
        }

        @Override
        public V get(T obj) {
            return (V)UnsafeHolder.getObjectVolatile(obj, this.offset);
        }

        @Override
        public void lazySet(T obj, V newValue) {
            throw new UnsupportedOperationException();
        }
    }
}

