/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.math;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.math.MutableNumber;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;

@InternalApi
public class MutableBigDecimal
extends MutableNumber {
    private static final long serialVersionUID = 1L;
    private BigDecimal value;

    @Override
    public Number toNumber() {
        return this.value;
    }

    @Override
    public void add(Number x) {
        if (x == null) {
            return;
        }
        this.value = this.value == null ? (BigDecimal)x : this.value.add((BigDecimal)x);
    }

    @Override
    public Number calcDivision(long count) {
        return this.value.divide(BigDecimal.valueOf(count));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = (BigDecimal)IOUtils.readObject(in);
    }
}

