/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.math;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.math.MutableNumber;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MutableFloat
extends MutableNumber {
    private static final long serialVersionUID = 1L;
    private float value;

    @Override
    public Number toNumber() {
        return Float.valueOf(this.value);
    }

    @Override
    public void add(Number x) {
        if (x != null) {
            this.value += x.floatValue();
        }
    }

    @Override
    public Number calcDivision(long count) {
        return Float.valueOf(this.value / (float)count);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readFloat();
    }
}

