/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.math;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.math.MutableNumber;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MutableShort
extends MutableNumber {
    private static final long serialVersionUID = 1L;
    private short value;

    @Override
    public Number toNumber() {
        return this.value;
    }

    @Override
    public void add(Number x) {
        if (x != null) {
            this.value = (short)(this.value + x.shortValue());
        }
    }

    @Override
    public Number calcDivision(long count) {
        return (double)this.value / (double)count;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readShort();
    }
}

