/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.parsers;

import com.gigaspaces.internal.utils.parsers.AbstractParser;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDateTimeParser
extends AbstractParser {
    protected final String _desc;
    protected final String _pattern;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");

    protected AbstractDateTimeParser(String desc, String pattern) {
        this._desc = desc;
        this._pattern = pattern;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("> AbstractDateTimeParser desc=" + desc + ", pattern=" + this._pattern);
        }
    }

    protected Date parseDateTime(String s) throws SQLException {
        SimpleDateFormat format = new SimpleDateFormat(this._pattern);
        Date date = format.parse(s, new ParsePosition(0));
        if (date == null) {
            throw new SQLException("Wrong " + this._desc + " format, expected format=[" + this._pattern + "], provided=[" + s + "]", "GSP", -132);
        }
        return date;
    }
}

