/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.parsers;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.parsers.AbstractParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;

@InternalApi
public class ConventionObjectParser {
    public static AbstractParser getConventionParserIfAvailable(Class<?> clazz) {
        AbstractParser parser;
        Class[] supportedArgTypes;
        for (Class type : supportedArgTypes = new Class[]{String.class, CharSequence.class, Object.class}) {
            parser = ConventionObjectParser.createMethodParserIfExists(clazz, "parse", type);
            if (parser == null) continue;
            return parser;
        }
        for (Class type : supportedArgTypes) {
            parser = ConventionObjectParser.createMethodParserIfExists(clazz, "valueOf", type);
            if (parser == null) continue;
            return parser;
        }
        for (Class type : supportedArgTypes) {
            parser = ConventionObjectParser.createConstructorParserIfExists(clazz, type);
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    private static AbstractParser createMethodParserIfExists(Class<?> clazz, String methodName, Class<?> paramType) {
        try {
            Method method = clazz.getMethod(methodName, paramType);
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            if (!clazz.isAssignableFrom(method.getReturnType())) {
                return null;
            }
            return new MethodParser(method);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static AbstractParser createConstructorParserIfExists(Class<?> clazz, Class<?> paramType) {
        try {
            Constructor<?> constructor = clazz.getConstructor(paramType);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                return null;
            }
            return new ConstructorParser(constructor);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static class ConstructorParser
    extends AbstractParser {
        private final Constructor constructor;

        private ConstructorParser(Constructor constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object parse(String s) throws SQLException {
            try {
                return this.constructor.newInstance(s);
            }
            catch (Exception e) {
                throw new SQLException("Failed to parse " + s + " to " + this.constructor.getDeclaringClass().getName(), e);
            }
        }
    }

    private static class MethodParser
    extends AbstractParser {
        private final Method method;

        private MethodParser(Method method) {
            this.method = method;
        }

        @Override
        public Object parse(String s) throws SQLException {
            try {
                return this.method.invoke(null, s);
            }
            catch (Exception e) {
                throw new SQLException("Failed to parse " + s + " to " + this.method.getDeclaringClass().getName(), e);
            }
        }
    }
}

