/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.pool;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResource;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourceFactory;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourcePool;
import com.j_spaces.kernel.pool.IResourceProcedure;
import com.j_spaces.kernel.pool.ResourcePool;
import java.util.concurrent.atomic.AtomicLong;

@InternalApi
public class MemoryBoundedResourcePool<T extends IMemoryAwareResource>
extends ResourcePool<T>
implements IMemoryAwareResourcePool {
    private final long _poolMemoryBounds;
    private final Object _allocateCheckLock = new Object();
    private final IMemoryAwareResourceFactory<T> _resourceFactory;

    public MemoryBoundedResourcePool(IMemoryAwareResourceFactory<T> resourceFactory, int minResources, int maxResources, long poolMemoryBounds) {
        super(resourceFactory, minResources, maxResources);
        this._resourceFactory = resourceFactory;
        this._poolMemoryBounds = poolMemoryBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T tryAllocateNewPooledResource() {
        Object object = this._allocateCheckLock;
        synchronized (object) {
            long usedMemory = this.CalculateUsedMemory();
            if (usedMemory >= this._poolMemoryBounds) {
                return null;
            }
            return this._resourceFactory.allocate(this);
        }
    }

    protected long CalculateUsedMemory() {
        final AtomicLong usedMemory = new AtomicLong(0L);
        this.forAllResources(new IResourceProcedure<T>(){

            @Override
            public void invoke(T resource) {
                usedMemory.addAndGet(resource.getUsedMemory());
            }
        });
        return usedMemory.get();
    }

    @Override
    public boolean isLimitReached(long length) {
        return this.CalculateUsedMemory() + length >= this._poolMemoryBounds;
    }
}

