/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.threadlocal;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.threadlocal.AbstractResource;
import com.gigaspaces.internal.utils.threadlocal.PoolFactory;
import java.util.ArrayList;

@InternalApi
public class ThreadLocalPool<T extends AbstractResource> {
    private final ThreadLocal<ArrayList<T>> _SLHolderPool;
    private final PoolFactory<T> _factory;

    public ThreadLocalPool(PoolFactory<T> factory) {
        this._factory = factory;
        this._SLHolderPool = new ThreadLocal<ArrayList<T>>(){

            @Override
            protected ArrayList<T> initialValue() {
                return new ArrayList();
            }
        };
    }

    public T get() {
        AbstractResource resource = null;
        ArrayList<T> list = this._SLHolderPool.get();
        for (int i = 0; i < list.size(); ++i) {
            resource = (AbstractResource)list.get(i);
            if (!resource.isAvaliable()) continue;
            resource.setAvaliable(false);
            return (T)resource;
        }
        resource = (AbstractResource)this._factory.create();
        list.add(resource);
        return (T)resource;
    }
}

