/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.xslt;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.XmlUtils;
import com.j_spaces.kernel.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@InternalApi
public class XSLTConverter {
    private static TransformerFactory tFactory;
    private static SchemaFactory schemaFactory;
    private static Schema schemaXSD;
    private static final boolean validXMLSchema;
    private static final Logger _logger;

    public static Node transformDOM2DOM(InputStream _DOMInputStream, InputStream _XSLInputStream) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException, ParserConfigurationException {
        if (tFactory == null) {
            tFactory = TransformerFactory.newInstance();
        }
        Transformer transformer = tFactory.newTransformer(new StreamSource(_XSLInputStream));
        Document convertedDoc = XmlUtils.getDocumentBuilder().newDocument();
        DOMResult sr = new DOMResult(convertedDoc);
        StreamSource ss = new StreamSource(_DOMInputStream);
        transformer.transform(ss, sr);
        Node retDOMnode = sr.getNode();
        return retDOMnode;
    }

    private static void initClusterXSDSchema() throws SAXException, IllegalArgumentException {
        if (schemaXSD == null) {
            schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(new DefaultErrorHandler());
            schemaXSD = schemaFactory.newSchema(ResourceLoader.getResourceURL("clusterXML-Schema.xsd"));
        }
    }

    public static void validateClusterDocument(Node validatedXmlDocument) throws SAXException, IOException {
        if (validXMLSchema) {
            Validator validator;
            block13: {
                validator = null;
                try {
                    XSLTConverter.initClusterXSDSchema();
                }
                catch (SAXException saxE) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to create XML xsd validator. Will not validate the cluster configuration due to:  " + saxE.toString(), saxE);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block13;
                    _logger.log(Level.SEVERE, "Failed to create XML xsd validator. Will not validate the cluster configuration due to:  " + iae.toString(), iae);
                }
            }
            if (schemaXSD != null) {
                validator = schemaXSD.newValidator();
                validator.setErrorHandler(new DefaultErrorHandler());
                Attr xpathAttr = null;
                boolean exceptionThrown = false;
                try {
                    Attr attr;
                    Node attrNode = validatedXmlDocument.getFirstChild();
                    if (attrNode != null && attrNode instanceof Element && (attr = (Attr)attrNode.getAttributes().getNamedItem("xmlns")) != null && (xpathAttr = ((Element)attrNode).removeAttributeNode(attr)) != null && _logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "In order the cluster schema xsl validation succeeds you need to remove the following xsl  header attribute. \n" + xpathAttr + "\nCurrently we bypassed the validation and continued as expected.");
                    }
                }
                catch (Exception e) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "In order the cluster schema xsl validation succeeds you need to remove the following xsl  header attribute. \n" + xpathAttr + "\nException thrown before validating: " + e.getMessage());
                    }
                    exceptionThrown = true;
                }
                if (xpathAttr == null && !exceptionThrown) {
                    if (validator != null && validXMLSchema) {
                        validator.validate(new DOMSource(validatedXmlDocument));
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Validated successfully the cluster configuration using the XML xsd validator: " + validator.toString());
                    }
                }
            }
        }
    }

    public static Node transformDOM2DOM(Document _DOMDoc, InputStream _XSLInputStream) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Document convertedDoc = XmlUtils.getDocumentBuilder().newDocument();
        if (tFactory == null) {
            tFactory = TransformerFactory.newInstance();
        }
        if (!tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") || !tFactory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            throw new TransformerConfigurationException("The currently used XSL TransformerFactory does not support required features: " + System.getProperty("javax.xml.transform.TransformerFactory Canceled the cluster XSL configuration transformation."));
        }
        Transformer transformer = tFactory.newTransformer(new StreamSource(_XSLInputStream));
        DOMResult sr = new DOMResult(convertedDoc);
        DOMSource domSource = new DOMSource(_DOMDoc);
        transformer.transform(domSource, sr);
        Node retDOMnode = sr.getNode();
        XSLTConverter.validateClusterDocument(retDOMnode);
        return retDOMnode;
    }

    public static void main(String[] args) throws TransformerConfigurationException, FileNotFoundException, TransformerException, IOException, ParserConfigurationException {
        InputStream members = XSLTConverter.class.getResourceAsStream(args[0]);
        InputStream policy = XSLTConverter.class.getResourceAsStream(args[1]);
        Node retNode = XSLTConverter.transformDOM2DOM(members, policy);
    }

    static {
        validXMLSchema = Boolean.parseBoolean(System.getProperty("com.gs.xmlschema.validation", "true"));
        _logger = Logger.getLogger("com.gigaspaces.core.config");
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            int line = spe.getLineNumber();
            int column = spe.getColumnNumber();
            StringBuilder sb = new StringBuilder("Parsing validation error - ");
            if (line != -1) {
                sb.append(" line: " + line);
            }
            if (column != -1) {
                sb.append(" column: " + column);
            }
            sb.append(" : " + spe.getMessage());
            return sb.toString();
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            System.err.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            throw new SAXException(this.getParseExceptionInfo(spe));
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

