/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.xml;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.XmlUtils;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@InternalApi
public class XmlParser {
    private final Document xmlDocument;
    private final XPath xPath;

    private XmlParser(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    public static XmlParser fromPath(String fileName) {
        try {
            return new XmlParser(XmlUtils.getDocumentBuilder().parse(fileName));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to parse '" + fileName + "'", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to parse '" + fileName + "'", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse '" + fileName + "'", e);
        }
    }

    public NodeList getNodes(String expression) {
        try {
            return (NodeList)this.xPath.evaluate(expression, this.xmlDocument.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to evaluate XPath expression '" + expression + "'", e);
        }
    }

    public Node getNode(String expression) {
        try {
            return (Node)this.xPath.evaluate(expression, this.xmlDocument.getDocumentElement(), XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to evaluate XPath expression '" + expression + "'", e);
        }
    }

    public static Properties parseProperties(Element element, String keyAttribute, String valueAttribute) {
        Properties properties = new Properties();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element property = (Element)node;
            properties.put(property.getAttribute(keyAttribute), property.getAttribute(valueAttribute));
        }
        return properties;
    }
}

