/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AllLogEntryMatcher;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatcherFilter;

public class AfterEntryLogEntryMatcher
extends LogEntryMatcherFilter {
    private static final long serialVersionUID = 1L;
    private final long filePosition;
    private final long position;
    private final boolean inclusive;
    private transient long lastFilePosition;

    public AfterEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry) {
        this(logEntries, logEntry, false);
    }

    public AfterEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry, boolean inclusive) {
        this(logEntries, logEntry, inclusive, new AllLogEntryMatcher());
    }

    public AfterEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry, LogEntryMatcher matcher) {
        this(logEntries, logEntry, false, matcher);
    }

    public AfterEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry, boolean inclusive, LogEntryMatcher matcher) {
        super(matcher);
        LogEntry fileMarker = logEntries.findFileMarkerFor(logEntry);
        this.filePosition = fileMarker.getPosition();
        this.position = logEntry.getPosition();
        this.inclusive = inclusive;
    }

    @Override
    protected boolean filterJustLogs() {
        return false;
    }

    @Override
    protected LogEntryMatcher.Operation filter(LogEntry entry) {
        if (entry.isFileMarker()) {
            this.lastFilePosition = entry.getPosition();
            if (entry.getPosition() >= this.filePosition) {
                return LogEntryMatcher.Operation.CONTINUE;
            }
            return LogEntryMatcher.Operation.BREAK;
        }
        if (!entry.isLog()) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (this.lastFilePosition != this.filePosition) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (this.inclusive && entry.getPosition() >= this.position) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (!this.inclusive && entry.getPosition() > this.position) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        return LogEntryMatcher.Operation.BREAK;
    }
}

