/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AllLogEntryMatcher;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatcherFilter;
import com.gigaspaces.log.LogEntryMatchers;
import java.text.ParseException;

public class AfterTimeLogEntryMatcher
extends LogEntryMatcherFilter {
    private static final long serialVersionUID = 1L;
    protected long timestamp;
    private boolean inclusive;

    public AfterTimeLogEntryMatcher(String time) throws ParseException {
        this(time, false);
    }

    public AfterTimeLogEntryMatcher(String time, boolean inclusive) throws ParseException {
        this(time, "yyyy-MM-dd HH:mm:ss", inclusive);
    }

    public AfterTimeLogEntryMatcher(String time, String format) throws ParseException {
        this(time, format, false);
    }

    public AfterTimeLogEntryMatcher(String time, String format, boolean inclusive) throws ParseException {
        this(time, format, inclusive, new AllLogEntryMatcher());
    }

    public AfterTimeLogEntryMatcher(String time, boolean inclusive, LogEntryMatcher matcher) throws ParseException {
        this(time, "yyyy-MM-dd HH:mm:ss", inclusive, matcher);
    }

    public AfterTimeLogEntryMatcher(String time, LogEntryMatcher matcher) throws ParseException {
        this(time, "yyyy-MM-dd HH:mm:ss", false, matcher);
    }

    public AfterTimeLogEntryMatcher(String time, String format, LogEntryMatcher matcher) throws ParseException {
        this(time, format, false, matcher);
    }

    public AfterTimeLogEntryMatcher(String time, String format, boolean inclusive, LogEntryMatcher matcher) throws ParseException {
        this(LogEntryMatchers.createDateFormat(format).parse(time).getTime(), inclusive, matcher);
    }

    public AfterTimeLogEntryMatcher(long timestamp) {
        this(timestamp, (LogEntryMatcher)new AllLogEntryMatcher());
    }

    public AfterTimeLogEntryMatcher(long timestamp, LogEntryMatcher matcher) {
        this(timestamp, false, matcher);
    }

    public AfterTimeLogEntryMatcher(long timestamp, boolean inclusive) {
        this(timestamp, inclusive, (LogEntryMatcher)new AllLogEntryMatcher());
    }

    public AfterTimeLogEntryMatcher(long timestamp, boolean inclusive, LogEntryMatcher matcher) {
        super(matcher);
        this.timestamp = timestamp;
        this.inclusive = inclusive;
    }

    @Override
    protected LogEntryMatcher.Operation filter(LogEntry entry) {
        if (this.inclusive && entry.getTimestamp() >= this.timestamp) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (!this.inclusive && entry.getTimestamp() > this.timestamp) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        return LogEntryMatcher.Operation.BREAK;
    }
}

