/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AllLogEntryMatcher;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatcherFilter;

public class BeforeEntryLogEntryMatcher
extends LogEntryMatcherFilter {
    private static final long serialVersionUID = 1L;
    private final long filePosition;
    private final long position;
    private final boolean inclusive;
    private transient long lastFilePosition;

    public BeforeEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry) {
        this(logEntries, logEntry, false);
    }

    public BeforeEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry, boolean inclusive) {
        this(logEntries, logEntry, inclusive, new AllLogEntryMatcher());
    }

    public BeforeEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry, LogEntryMatcher matcher) {
        this(logEntries, logEntry, false, matcher);
    }

    public BeforeEntryLogEntryMatcher(LogEntries logEntries, LogEntry logEntry, boolean inclusive, LogEntryMatcher matcher) {
        super(matcher);
        this.filePosition = logEntries.findFileMarkerFor(logEntry).getPosition();
        this.position = logEntry.getPosition();
        this.inclusive = inclusive;
    }

    @Override
    protected boolean filterJustLogs() {
        return false;
    }

    @Override
    protected LogEntryMatcher.Operation filter(LogEntry entry) {
        if (entry.isFileMarker()) {
            this.lastFilePosition = entry.getPosition();
            if (entry.getPosition() > this.filePosition) {
                return LogEntryMatcher.Operation.IGNORE;
            }
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (!entry.isLog()) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (this.lastFilePosition != this.filePosition) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (this.inclusive && entry.getPosition() <= this.position) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (!this.inclusive && entry.getPosition() < this.position) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        return LogEntryMatcher.Operation.IGNORE;
    }
}

