/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AllLogEntryMatcher;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatcherFilter;
import com.gigaspaces.log.LogEntryMatchers;
import java.text.ParseException;

public class BeforeTimeLogEntryMatcher
extends LogEntryMatcherFilter {
    private static final long serialVersionUID = 1L;
    private long timestamp;
    private boolean inclusive;

    public BeforeTimeLogEntryMatcher(String time) throws ParseException {
        this(time, false);
    }

    public BeforeTimeLogEntryMatcher(String time, boolean inclusive) throws ParseException {
        this(time, "yyyy-MM-dd HH:mm:ss", inclusive);
    }

    public BeforeTimeLogEntryMatcher(String time, String format) throws ParseException {
        this(time, format, false);
    }

    public BeforeTimeLogEntryMatcher(String time, String format, boolean inclusive) throws ParseException {
        this(time, format, inclusive, new AllLogEntryMatcher());
    }

    public BeforeTimeLogEntryMatcher(String time, boolean inclusive, LogEntryMatcher matcher) throws ParseException {
        this(time, "yyyy-MM-dd HH:mm:ss", inclusive, matcher);
    }

    public BeforeTimeLogEntryMatcher(String time, LogEntryMatcher matcher) throws ParseException {
        this(time, "yyyy-MM-dd HH:mm:ss", false, matcher);
    }

    public BeforeTimeLogEntryMatcher(String time, String format, LogEntryMatcher matcher) throws ParseException {
        this(time, format, false, matcher);
    }

    public BeforeTimeLogEntryMatcher(String time, String format, boolean inclusive, LogEntryMatcher matcher) throws ParseException {
        this(LogEntryMatchers.createDateFormat(format).parse(time).getTime(), inclusive, matcher);
    }

    public BeforeTimeLogEntryMatcher(long timestamp) {
        this(timestamp, (LogEntryMatcher)new AllLogEntryMatcher());
    }

    public BeforeTimeLogEntryMatcher(long timestamp, LogEntryMatcher matcher) {
        this(timestamp, false, matcher);
    }

    public BeforeTimeLogEntryMatcher(long timestamp, boolean inclusive) {
        this(timestamp, inclusive, (LogEntryMatcher)new AllLogEntryMatcher());
    }

    public BeforeTimeLogEntryMatcher(long timestamp, boolean inclusive, LogEntryMatcher matcher) {
        super(matcher);
        this.timestamp = timestamp;
        this.inclusive = inclusive;
    }

    @Override
    protected boolean filterJustLogs() {
        return false;
    }

    @Override
    protected LogEntryMatcher.Operation filter(LogEntry entry) {
        if (entry.isFileMarker()) {
            if (entry.getTimestamp() >= this.timestamp) {
                return LogEntryMatcher.Operation.IGNORE;
            }
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (!entry.isLog()) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (this.inclusive && entry.getTimestamp() <= this.timestamp) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        if (!this.inclusive && entry.getTimestamp() < this.timestamp) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        return LogEntryMatcher.Operation.IGNORE;
    }
}

