/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.LogEntries;
import java.io.Serializable;
import java.util.ArrayList;

public class CompoundLogEntries
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final LogEntries[] entries;
    private transient LogEntries[] safeEntries;

    public CompoundLogEntries(LogEntries[] entries) {
        this.entries = entries;
    }

    public LogEntries[] getEntries() {
        return this.entries;
    }

    public LogEntries[] getSafeEntries() {
        if (this.safeEntries != null) {
            return this.safeEntries;
        }
        ArrayList<LogEntries> result = new ArrayList<LogEntries>(this.entries.length);
        for (LogEntries x : this.entries) {
            if (x == null) continue;
            result.add(x);
        }
        this.safeEntries = result.toArray(new LogEntries[result.size()]);
        return this.safeEntries;
    }

    public boolean isEmpty() {
        if (this.entries == null || this.entries.length == 0) {
            return true;
        }
        for (LogEntries x : this.entries) {
            if (x == null) continue;
            return false;
        }
        return true;
    }
}

