/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AfterEntryLogEntryMatcher;
import com.gigaspaces.log.ClientLogEntryMatcherCallback;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.StreamLogEntryMatcher;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContinuousLogEntryMatcher
implements LogEntryMatcher,
ClientLogEntryMatcherCallback,
StreamLogEntryMatcher {
    private static final long serialVersionUID = 1L;
    private final LogEntryMatcher initialMatcher;
    private transient LogEntryMatcher continousMatcher;
    private final Map<LogEntryMatcher.InitializationContext, LogEntryMatcher> matchers;
    private transient LogEntryMatcher serverSideMatcher;

    public ContinuousLogEntryMatcher(LogEntryMatcher initialMatcher, LogEntryMatcher continousMatcher) {
        this.initialMatcher = initialMatcher;
        this.continousMatcher = continousMatcher;
        this.matchers = new HashMap<LogEntryMatcher.InitializationContext, LogEntryMatcher>();
    }

    @Override
    public void initialize(LogEntryMatcher.InitializationContext context) throws IOException {
        LogEntryMatcher matcher = this.matchers.get(context);
        if (matcher == null) {
            matcher = this.initialMatcher;
            this.matchers.put(context, matcher);
        }
        this.serverSideMatcher = matcher;
        this.serverSideMatcher.initialize(context);
    }

    @Override
    public List<LogEntry> entries() {
        return this.serverSideMatcher.entries();
    }

    @Override
    public LogEntryMatcher.Operation match(LogEntry entry) {
        return this.serverSideMatcher.match(entry);
    }

    @Override
    public LogEntries clientSideProcess(LogEntries entries) {
        List<LogEntry> justLogs;
        LogEntryMatcher.InitializationContext context = new LogEntryMatcher.InitializationContext(entries);
        LogEntryMatcher matcher = this.matchers.get(context);
        if (matcher == null) {
            matcher = this.initialMatcher;
            this.matchers.put(context, matcher);
        }
        if (matcher instanceof ClientLogEntryMatcherCallback) {
            entries = ((ClientLogEntryMatcherCallback)matcher).clientSideProcess(entries);
        }
        if (!(justLogs = entries.logEntries()).isEmpty()) {
            LogEntry lastEntry = justLogs.get(justLogs.size() - 1);
            matcher = this.continousMatcher != null ? new AfterEntryLogEntryMatcher(entries, lastEntry, this.continousMatcher) : new AfterEntryLogEntryMatcher(entries, lastEntry);
            this.matchers.put(context, matcher);
        }
        return entries;
    }
}

