/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AfterEntryLogEntryMatcher;
import com.gigaspaces.log.ClientLogEntryMatcherCallback;
import com.gigaspaces.log.FirstFileLogEntryMatcher;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.NoneLogEntryMatcher;
import com.gigaspaces.log.SameFileLogEntryMatcher;
import com.gigaspaces.log.StreamLogEntryMatcher;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ForwardChunkLogEntryMatcher
implements LogEntryMatcher,
ClientLogEntryMatcherCallback,
StreamLogEntryMatcher {
    private static final long serialVersionUID = 1L;
    private final LogEntryMatcher origMatcher;
    private final Map<LogEntryMatcher.InitializationContext, Holder> matchers;
    private transient LogEntryMatcher serverSideMatcher;

    public ForwardChunkLogEntryMatcher(LogEntryMatcher matcher) {
        this.origMatcher = matcher;
        this.matchers = new HashMap<LogEntryMatcher.InitializationContext, Holder>();
    }

    @Override
    public void initialize(LogEntryMatcher.InitializationContext context) throws IOException {
        Holder holder = this.matchers.get(context);
        if (holder == null) {
            holder = new Holder(new FirstFileLogEntryMatcher(this.origMatcher), 0L);
            this.matchers.put(context, holder);
        }
        this.serverSideMatcher = holder.matcher;
        this.serverSideMatcher.initialize(context);
    }

    @Override
    public List<LogEntry> entries() {
        return this.serverSideMatcher.entries();
    }

    @Override
    public LogEntryMatcher.Operation match(LogEntry entry) {
        return this.serverSideMatcher.match(entry);
    }

    @Override
    public LogEntries clientSideProcess(LogEntries entries) {
        List<LogEntry> logs;
        LogEntryMatcher.InitializationContext context = new LogEntryMatcher.InitializationContext(entries);
        Holder holder = this.matchers.get(context);
        if (holder == null) {
            holder = new Holder(new FirstFileLogEntryMatcher(this.origMatcher), 0L);
            this.matchers.put(context, holder);
        }
        if (holder.lastFilePosition == (long)entries.getTotalLogFiles()) {
            return null;
        }
        if (holder.matcher instanceof ClientLogEntryMatcherCallback) {
            entries = ((ClientLogEntryMatcherCallback)holder.matcher).clientSideProcess(entries);
        }
        if (!(logs = entries.logEntries()).isEmpty()) {
            LogEntry lastEntry = logs.get(logs.size() - 1);
            holder.matcher = new SameFileLogEntryMatcher(holder.lastFilePosition, new AfterEntryLogEntryMatcher(entries, lastEntry, this.origMatcher));
            return entries;
        }
        ++holder.lastFilePosition;
        if (holder.lastFilePosition == (long)entries.getTotalLogFiles()) {
            holder.matcher = new NoneLogEntryMatcher();
            return null;
        }
        holder.matcher = new SameFileLogEntryMatcher(holder.lastFilePosition, this.origMatcher);
        return entries;
    }

    private static class Holder
    implements Serializable {
        private static final long serialVersionUID = -2077404952794343627L;
        LogEntryMatcher matcher;
        long lastFilePosition;

        private Holder(LogEntryMatcher matcher, long lastFilePosition) {
            this.matcher = matcher;
            this.lastFilePosition = lastFilePosition;
        }
    }
}

