/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogProcessType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogEntries
implements Iterable<LogEntry>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private LogProcessType processType;
    private List<LogEntry> entries;
    private int totalLogFiles;
    private long pid;
    private long latestTimestamp;
    private String hostName = "";
    private String hostAddress = "";
    private transient List<LogEntry> justLogEntries;

    public LogEntries() {
    }

    public LogEntries(LogProcessType processType, long pid, String hostName, String hostAddress) {
        this(processType, new ArrayList<LogEntry>(0), 0, pid, 0L, hostName, hostAddress);
    }

    public LogEntries(LogProcessType processType, List<LogEntry> entries, int totalLogFiles, long pid, long latestTimestamp, String hostName, String hostAddress) {
        this.processType = processType;
        this.entries = entries;
        this.totalLogFiles = totalLogFiles;
        this.pid = pid;
        this.latestTimestamp = latestTimestamp;
        this.hostName = hostName;
        this.hostAddress = hostAddress;
    }

    public LogProcessType getProcessType() {
        return this.processType;
    }

    public List<LogEntry> getEntries() {
        return this.entries;
    }

    public long getPid() {
        return this.pid;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public long getLatestLogFileTimestamp() {
        return this.latestTimestamp;
    }

    public int getTotalLogFiles() {
        return this.totalLogFiles;
    }

    @Override
    public Iterator<LogEntry> iterator() {
        return this.entries.iterator();
    }

    public List<LogEntry> logEntries() {
        return this.typeEntries(LogEntry.Type.LOG);
    }

    public List<LogEntry> typeEntries(LogEntry.Type type) {
        if (type == LogEntry.Type.LOG && this.justLogEntries != null) {
            return this.justLogEntries;
        }
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        for (LogEntry entry : this.entries) {
            if (entry.getType() != type) continue;
            result.add(entry);
        }
        if (type == LogEntry.Type.LOG) {
            this.justLogEntries = result;
        }
        return result;
    }

    public LogEntry findFileMarkerFor(LogEntry logEntry) {
        if (logEntry.getType() == LogEntry.Type.FILE_MARKER) {
            return logEntry;
        }
        int index = this.entries.indexOf(logEntry);
        if (index == -1) {
            throw new IllegalArgumentException("Log entry not found in entries");
        }
        for (int i = 0; i < index; ++i) {
            LogEntry candidate = this.entries.get(i);
            if (candidate.getType() != LogEntry.Type.FILE_MARKER) continue;
            return candidate;
        }
        throw new IllegalStateException("No file marker found in entries");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.processType);
        out.writeInt(this.totalLogFiles);
        out.writeLong(this.pid);
        out.writeLong(this.latestTimestamp);
        out.writeUTF(this.hostName);
        out.writeUTF(this.hostAddress);
        out.writeInt(this.entries.size());
        for (LogEntry entry : this.entries) {
            entry.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.processType = (LogProcessType)((Object)in.readObject());
        this.totalLogFiles = in.readInt();
        this.pid = in.readLong();
        this.latestTimestamp = in.readLong();
        this.hostName = in.readUTF();
        this.hostAddress = in.readUTF();
        int size = in.readInt();
        this.entries = new ArrayList<LogEntry>(size);
        for (int i = 0; i < size; ++i) {
            LogEntry entry = new LogEntry();
            entry.readExternal(in);
            this.entries.add(entry);
        }
    }
}

