/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LogEntry
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static String lineSeparator = System.getProperty("line.separator");
    private long position;
    private Type type;
    private long timestamp;
    private String text;

    public LogEntry() {
    }

    public LogEntry(long position, Type type, long timestamp, String text) {
        this.position = position;
        this.type = type;
        this.timestamp = timestamp;
        this.text = text;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getPosition() {
        return this.position;
    }

    public String getText() {
        return this.text;
    }

    public String getTextWithLF() {
        return this.getText() + lineSeparator;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isLog() {
        return this.type == Type.LOG;
    }

    public boolean isFileMarker() {
        return this.type == Type.FILE_MARKER;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.position);
        out.writeByte(this.type.value);
        out.writeLong(this.timestamp);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_6_1)) {
            IOUtils.writeString(out, this.text);
        } else {
            out.writeUTF(this.text);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.position = in.readLong();
        this.type = Type.fromByte(in.readByte());
        this.timestamp = in.readLong();
        this.text = LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_6_1) ? IOUtils.readString(in) : in.readUTF();
    }

    public static enum Type {
        LOG(0),
        FILE_MARKER(1);

        byte value;

        private Type(byte value) {
            this.value = value;
        }

        public static Type fromByte(byte b) {
            if (b == 0) {
                return LOG;
            }
            if (b == 1) {
                return FILE_MARKER;
            }
            throw new IllegalArgumentException("Wrong type [" + b + "]");
        }
    }
}

