/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogProcessType;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public interface LogEntryMatcher
extends Serializable {
    public void initialize(InitializationContext var1) throws IOException;

    public List<LogEntry> entries();

    public Operation match(LogEntry var1);

    public static class InitializationContext
    implements Serializable {
        private static final long serialVersionUID = 3526789181040829025L;
        final String hostAddress;
        final String hostName;
        final long pid;
        final LogProcessType processType;

        public InitializationContext(LogEntries entries) {
            this(entries.getHostAddress(), entries.getHostName(), entries.getPid(), entries.getProcessType());
        }

        public InitializationContext(String hostAddress, String hostName, long pid, LogProcessType processType) {
            this.hostAddress = hostAddress;
            this.hostName = hostName;
            this.pid = pid;
            this.processType = processType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InitializationContext that = (InitializationContext)o;
            if (this.pid != that.pid) {
                return false;
            }
            if (this.hostAddress != null ? !this.hostAddress.equals(that.hostAddress) : that.hostAddress != null) {
                return false;
            }
            return this.processType == that.processType;
        }

        public int hashCode() {
            int result = this.hostAddress != null ? this.hostAddress.hashCode() : 0;
            result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
            result = 31 * result + (int)(this.pid ^ this.pid >>> 32);
            result = 31 * result + (this.processType != null ? this.processType.hashCode() : 0);
            return result;
        }
    }

    public static enum Operation {
        BREAK,
        CONTINUE,
        IGNORE;

    }
}

