/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import java.io.IOException;
import java.util.List;

public abstract class LogEntryMatcherFilter
implements LogEntryMatcher {
    private static final long serialVersionUID = -5843948024474262714L;
    private final LogEntryMatcher matcher;

    protected LogEntryMatcherFilter(LogEntryMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public void initialize(LogEntryMatcher.InitializationContext context) throws IOException {
        this.matcher.initialize(context);
    }

    @Override
    public List<LogEntry> entries() {
        return this.matcher.entries();
    }

    @Override
    public LogEntryMatcher.Operation match(LogEntry entry) {
        LogEntryMatcher.Operation op = this.doFilter(this, entry);
        if (op != null) {
            return op;
        }
        return this.matcher.match(entry);
    }

    protected boolean filterJustLogs() {
        return true;
    }

    protected abstract LogEntryMatcher.Operation filter(LogEntry var1);

    LogEntryMatcher.Operation doFilter(LogEntryMatcherFilter filter, LogEntry entry) {
        if (!filter.filterJustLogs() || filter.filterJustLogs() && entry.isLog()) {
            LogEntryMatcher.Operation op = this.filter(entry);
            if (op == LogEntryMatcher.Operation.BREAK) {
                return LogEntryMatcher.Operation.BREAK;
            }
            if (op == LogEntryMatcher.Operation.IGNORE) {
                return LogEntryMatcher.Operation.CONTINUE;
            }
        }
        return null;
    }
}

