/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AllLogEntryMatcher;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatcherFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexLogEntryMatcher
extends LogEntryMatcherFilter {
    private static final long serialVersionUID = 1L;
    private final String regex;
    private transient Matcher matcher;

    public static int regexFlags() {
        return 43;
    }

    public RegexLogEntryMatcher(String regex) {
        this(regex, new AllLogEntryMatcher());
    }

    public RegexLogEntryMatcher(String regex, LogEntryMatcher matcher) {
        super(matcher);
        this.regex = regex;
    }

    @Override
    public void initialize(LogEntryMatcher.InitializationContext context) throws IOException {
        super.initialize(context);
        this.matcher = Pattern.compile(this.regex, RegexLogEntryMatcher.regexFlags()).matcher("");
    }

    @Override
    protected LogEntryMatcher.Operation filter(LogEntry entry) {
        if (this.matcher.reset(entry.getText()).matches()) {
            return LogEntryMatcher.Operation.CONTINUE;
        }
        return LogEntryMatcher.Operation.IGNORE;
    }
}

