/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.AllLogEntryMatcher;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatcherFilter;

public class SameFileLogEntryMatcher
extends LogEntryMatcherFilter {
    private static final long serialVersionUID = 1L;
    private final long filePosition;

    public SameFileLogEntryMatcher(LogEntries logEntries, LogEntry logEntry) {
        this(logEntries, logEntry, new AllLogEntryMatcher());
    }

    public SameFileLogEntryMatcher(LogEntries logEntries, LogEntry logEntry, LogEntryMatcher matcher) {
        super(matcher);
        this.filePosition = logEntries.findFileMarkerFor(logEntry).getPosition();
    }

    public SameFileLogEntryMatcher(long filePosition) {
        this(filePosition, new AllLogEntryMatcher());
    }

    public SameFileLogEntryMatcher(long filePosition, LogEntryMatcher matcher) {
        super(matcher);
        this.filePosition = filePosition;
    }

    @Override
    protected boolean filterJustLogs() {
        return false;
    }

    @Override
    protected LogEntryMatcher.Operation filter(LogEntry entry) {
        if (entry.isFileMarker()) {
            if (entry.getPosition() > this.filePosition) {
                return LogEntryMatcher.Operation.IGNORE;
            }
            if (entry.getPosition() < this.filePosition) {
                return LogEntryMatcher.Operation.BREAK;
            }
        }
        return LogEntryMatcher.Operation.CONTINUE;
    }
}

