/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.log;

import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import java.util.ArrayList;
import java.util.List;

public class SizeLogEntryMatcher
implements LogEntryMatcher {
    private static final long serialVersionUID = 1L;
    private int size;
    private transient LogEntry[] entries;
    private transient int index;
    private transient LogEntry lastFileMarker;

    public SizeLogEntryMatcher(int size) {
        this.size = size;
    }

    @Override
    public void initialize(LogEntryMatcher.InitializationContext context) {
        this.entries = new LogEntry[this.size];
    }

    @Override
    public List<LogEntry> entries() {
        int i;
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        for (i = this.index; i < this.size; ++i) {
            if (this.entries[i] == null) {
                return result;
            }
            result.add(this.entries[i]);
        }
        for (i = 0; i < this.index; ++i) {
            if (this.entries[i] == null) {
                return result;
            }
            result.add(this.entries[i]);
        }
        boolean found = false;
        for (LogEntry entry : this.entries) {
            if (entry != this.lastFileMarker) continue;
            found = true;
            break;
        }
        if (!found) {
            result.add(this.lastFileMarker);
        }
        return result;
    }

    @Override
    public LogEntryMatcher.Operation match(LogEntry entry) {
        if (entry.isFileMarker()) {
            this.lastFileMarker = entry;
        }
        this.entries[this.index++] = entry;
        if (this.index == this.size) {
            this.index = 0;
        }
        return LogEntryMatcher.Operation.CONTINUE;
    }
}

