/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.api.InternalApi;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@InternalApi
public class UnsafeLevelLogger
extends Logger {
    private static final int offValue = Level.OFF.intValue();
    private final Logger _logger;
    private int _logLevel;
    private boolean _levelOverriden;

    protected UnsafeLevelLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        throw new UnsupportedOperationException();
    }

    public UnsafeLevelLogger(String name, Logger logger) {
        super(name, null);
        this._logger = logger;
    }

    public static UnsafeLevelLogger getLogger(String name) {
        return new UnsafeLevelLogger(name, Logger.getLogger(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        UnsafeLevelLogger unsafeLevelLogger = this;
        synchronized (unsafeLevelLogger) {
            this._levelOverriden = true;
            this._logLevel = newLevel.intValue();
        }
        this._logger.setLevel(newLevel);
    }

    @Override
    public boolean isLoggable(Level level) {
        if (!this._levelOverriden) {
            return this._logger.isLoggable(level);
        }
        return level.intValue() >= this._logLevel && this._logLevel != offValue;
    }

    @Override
    public void log(LogRecord record) {
        this._logger.log(record);
    }

    @Override
    public Filter getFilter() {
        return this._logger.getFilter();
    }

    @Override
    public synchronized Handler[] getHandlers() {
        return this._logger.getHandlers();
    }

    @Override
    public Level getLevel() {
        return this._logger.getLevel();
    }

    @Override
    public Logger getParent() {
        return this._logger.getParent();
    }

    @Override
    public boolean getUseParentHandlers() {
        return this._logger.getUseParentHandlers();
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this._logger.getResourceBundle();
    }

    @Override
    public String getResourceBundleName() {
        return this._logger.getResourceBundleName();
    }

    public int hashCode() {
        return this._logger.hashCode();
    }

    public boolean equals(Object obj) {
        return this._logger.equals(obj);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        this._logger.removeHandler(handler);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this._logger.setFilter(newFilter);
    }

    @Override
    public void setParent(Logger parent) {
        this._logger.setParent(parent);
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this._logger.setUseParentHandlers(useParentHandlers);
    }
}

