/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.internal.lrmi.ConnectionUrlDescriptor;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.ServerPeer;
import com.gigaspaces.lrmi.nio.PAdapter;
import com.gigaspaces.start.SystemInfo;
import java.rmi.RemoteException;

@InternalApi
public class BaseServerPeer
implements ServerPeer {
    private final PAdapter _protocolAdapter;
    private final long _objectId;
    private final String _serviceDetails;
    private final long _objectClassLoader;
    private boolean _connected;
    private int _timeout;

    public BaseServerPeer(PAdapter protocolAdapter, long objectId, ClassLoader objectClassLoader, String serviceDetails) {
        this._protocolAdapter = protocolAdapter;
        this._objectId = objectId;
        this._serviceDetails = serviceDetails;
        try {
            this._objectClassLoader = protocolAdapter.getClassProvider().putClassLoader(objectClassLoader);
        }
        catch (RemoteException e) {
            throw new RuntimeException("exception caught while inserting the exported object class loader to the class provider list", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        BaseServerPeer baseServerPeer = this;
        synchronized (baseServerPeer) {
            return this._connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        BaseServerPeer baseServerPeer = this;
        synchronized (baseServerPeer) {
            this._connected = false;
        }
    }

    public Object getSecurityContext() {
        return null;
    }

    public void setSecurityContext(Object securityContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeout() {
        BaseServerPeer baseServerPeer = this;
        synchronized (baseServerPeer) {
            return this._timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(int timeout) {
        BaseServerPeer baseServerPeer = this;
        synchronized (baseServerPeer) {
            this._timeout = timeout;
        }
    }

    public PAdapter getProtocolAdapter() {
        return this._protocolAdapter;
    }

    @Override
    public long getObjectId() {
        return this._objectId;
    }

    @Override
    public long getObjectClassLoaderId() {
        return this._objectClassLoader;
    }

    @Override
    public void beforeExport(ITransportConfig config) throws RemoteException {
    }

    @Override
    public void afterUnexport(boolean force) throws RemoteException {
    }

    @Override
    public String getConnectionURL() {
        return new ConnectionUrlDescriptor(this._protocolAdapter.getName(), SystemInfo.singleton().network().getPublicHostId(), this._protocolAdapter.getPort(), SystemInfo.singleton().os().processId(), this._objectId, this._objectClassLoader, LRMIRuntime.getRuntime().getID(), this._serviceDetails).toUrl();
    }
}

