/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.exception.lrmi.ApplicationException;
import com.gigaspaces.exception.lrmi.ProtocolException;
import com.gigaspaces.internal.lrmi.LRMIProxyMonitoringDetailsImpl;
import com.gigaspaces.lrmi.ClientPeerInvocationHandler;
import com.gigaspaces.lrmi.ConnectionPool;
import com.gigaspaces.lrmi.ConnectionResource;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import com.gigaspaces.lrmi.nio.async.LRMIFuture;

@InternalApi
public class ConnPoolInvocationHandler
implements ClientPeerInvocationHandler {
    private final ConnectionPool _connPool;

    public ConnPoolInvocationHandler(ConnectionPool connPool) {
        this._connPool = connPool;
    }

    @Override
    public Object invoke(Object proxy, LRMIMethod lrmiMethod, Object[] args) throws Throwable {
        ConnectionResource clientPeer = null;
        boolean freeConnection = true;
        try {
            clientPeer = this._connPool.getConnection(lrmiMethod);
        }
        catch (Exception e) {
            if (lrmiMethod.isAsync) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                LRMIFuture result = (LRMIFuture)FutureContext.getFutureResult();
                if (result == null) {
                    result = new LRMIFuture(contextClassLoader);
                } else {
                    result.reset(contextClassLoader);
                }
                FutureContext.setFutureResult(result);
                result.setResult(e);
                return null;
            }
            throw e;
        }
        try {
            freeConnection = !lrmiMethod.isAsync;
            Object e = clientPeer.invoke(proxy, lrmiMethod, args, this._connPool);
            return e;
        }
        catch (ProtocolException ex) {
            throw ex.getCause();
        }
        catch (ApplicationException ex) {
            throw ex.getCause();
        }
        finally {
            if (clientPeer != null && freeConnection) {
                this._connPool.freeConnection(clientPeer);
            }
        }
    }

    @Override
    public long getGeneratedTraffic() {
        return this._connPool.getGeneratedTraffic();
    }

    @Override
    public long getReceivedTraffic() {
        return this._connPool.getReceivedTraffic();
    }

    @Override
    public void disable() {
        this._connPool.disable();
    }

    @Override
    public void enable() {
        this._connPool.enable();
    }

    @Override
    public void close() {
        this._connPool.close();
    }

    @Override
    public LRMIProxyMonitoringDetailsImpl getMonitoringDetails() {
        return this._connPool.getMonitoringDetails();
    }
}

