/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.internal.backport.java.util.concurrent.atomic.LongAdder;
import com.gigaspaces.internal.lrmi.ConnectionUrlDescriptor;
import com.gigaspaces.internal.lrmi.LRMIProxyMonitoringDetailsImpl;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ConnectionFactory;
import com.gigaspaces.lrmi.ConnectionResource;
import com.gigaspaces.lrmi.DisableStubProcedure;
import com.gigaspaces.lrmi.DynamicSmartStub;
import com.gigaspaces.lrmi.GeneratedTrafficProcedure;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.ProtocolAdapter;
import com.gigaspaces.lrmi.ReceivedTrafficProcedure;
import com.j_spaces.kernel.pool.BlockingResourcePool;
import com.j_spaces.kernel.pool.IResourcePool;
import com.j_spaces.kernel.pool.IResourceProcedure;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

@InternalApi
public class ConnectionPool {
    private static final LongAdder activeConnections = new LongAdder();
    private static final boolean WAIT_INDEFINITELY_FOR_CONNECTION = Boolean.valueOf(System.getProperty("com.gs.transport_protocol.lrmi.fail-async-on-max-connection-exceeded", String.valueOf(false))) == false;
    private final IResourcePool<ConnectionResource> _peersPool;
    private final String _connectionURL;
    private final String _serviceDetails;
    private final PlatformLogicalVersion _serviceVersion;
    private volatile boolean _disabled;
    private volatile boolean _closed;

    public static LongAdder getActiveConnectionsCounter() {
        return activeConnections;
    }

    public ConnectionPool(ProtocolAdapter protocolAdapter, ITransportConfig config, String connectionURL, PlatformLogicalVersion serviceVersion) {
        int maxConns = config.getConnectionPoolSize();
        if (maxConns <= 0) {
            throw new IllegalArgumentException("Max connection pool can't be less or equals zero.");
        }
        this._connectionURL = connectionURL;
        this._serviceVersion = serviceVersion;
        this._peersPool = new BlockingResourcePool<ConnectionResource>(new ConnectionFactory(protocolAdapter, config, serviceVersion), 0, maxConns);
        this._serviceDetails = ConnectionPool.extractServiceDetailsFromConnectionUrl(this._connectionURL);
    }

    private static String extractServiceDetailsFromConnectionUrl(String connectionUrl) {
        if (connectionUrl == null) {
            return "";
        }
        String serviceDetails = ConnectionUrlDescriptor.fromUrl(connectionUrl).getServiceDetails();
        return serviceDetails != null ? serviceDetails : "";
    }

    public ConnectionResource getConnection(LRMIMethod lrmiMethod) throws RemoteException, MalformedURLException {
        ConnectionResource conn;
        block9: {
            boolean waitForConnection = true;
            if (lrmiMethod.isAsync) {
                waitForConnection = WAIT_INDEFINITELY_FOR_CONNECTION;
            }
            conn = this._peersPool.getResource(waitForConnection);
            try {
                if (this._closed) {
                    conn.disconnect();
                    conn.close();
                    DynamicSmartStub.throwProxyClosedExeption(this._connectionURL);
                }
                if (conn.isConnected()) break block9;
                if (this._disabled) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    throw new RemoteException("LRMI force disconnection enabled for this stub");
                }
                conn.connect(this._connectionURL, lrmiMethod);
            }
            catch (RemoteException ex) {
                this.freeConnection(conn);
                throw ex;
            }
            catch (MalformedURLException ex) {
                this.freeConnection(conn);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.freeConnection(conn);
                throw ex;
            }
        }
        activeConnections.increment();
        return conn;
    }

    public void freeConnection(ConnectionResource clientPeer) {
        activeConnections.decrement();
        this._peersPool.freeResource(clientPeer);
    }

    public long getGeneratedTraffic() {
        GeneratedTrafficProcedure procedure = new GeneratedTrafficProcedure();
        this._peersPool.forAllResources(procedure);
        return procedure.getGeneratedTraffic();
    }

    public long getReceivedTraffic() {
        ReceivedTrafficProcedure procedure = new ReceivedTrafficProcedure();
        this._peersPool.forAllResources(procedure);
        return procedure.getReceivedTraffic();
    }

    public void disable() {
        this._disabled = true;
        DisableStubProcedure procedure = new DisableStubProcedure();
        this._peersPool.forAllResources(procedure);
    }

    public void enable() {
        this._disabled = false;
    }

    public LRMIProxyMonitoringDetailsImpl getMonitoringDetails() {
        final LRMIProxyMonitoringDetailsImpl monitoringDetails = new LRMIProxyMonitoringDetailsImpl(this._connectionURL, this._serviceDetails, this._serviceVersion);
        this._peersPool.forAllResources(new IResourceProcedure<ConnectionResource>(){

            @Override
            public void invoke(ConnectionResource resource) {
                monitoringDetails.addConnectionResource(resource);
            }
        });
        return monitoringDetails;
    }

    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        this._peersPool.forAllResources(new IResourceProcedure<ConnectionResource>(){

            @Override
            public void invoke(ConnectionResource resource) {
                boolean acquired = resource.acquire();
                try {
                    if (acquired) {
                        resource.disconnect();
                    }
                }
                finally {
                    resource.close();
                    if (acquired) {
                        resource.release();
                    }
                }
            }
        });
    }
}

