/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.INetworkMapper;
import com.gigaspaces.lrmi.ServerAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class DefaultNetworkMapper
implements INetworkMapper {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final String NETWORK_MAPPING_FILE = System.getProperty("com.gs.transport_protocol.lrmi.network-mapping-file", "config/network_mapping.config");
    private static final String MALFORMED_FORMAT_MSG = "Unsupported format of network mapping file, expected format is separated lines each contains a separate mapping: <original ip>:<original port>,<mapped ip>:<mapped port> for instance 10.0.0.1:4162,212.321.1.1:3000";
    private final HashMap<ServerAddress, ServerAddress> _mapping = new HashMap();

    public DefaultNetworkMapper() {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(NETWORK_MAPPING_FILE);
        if (resourceAsStream == null) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("Could not locate networking mapping file " + NETWORK_MAPPING_FILE + " in the classpath, no mapping created");
            }
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] split = line.split(",");
                if (split.length != 2) {
                    throw new IllegalArgumentException(MALFORMED_FORMAT_MSG);
                }
                ServerAddress original = this.getAddress(split[0].trim());
                ServerAddress mapped = this.getAddress(split[1].trim());
                if (this._mapping.containsKey(original)) {
                    throw new IllegalArgumentException("Address " + original + " is already mapped to " + this._mapping.get(original));
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Adding mapping of " + original + " to " + mapped);
                }
                this._mapping.put(original, mapped);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while parsing the network mapping file " + NETWORK_MAPPING_FILE, e);
        }
    }

    private ServerAddress getAddress(String string) {
        String[] split = string.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException(MALFORMED_FORMAT_MSG);
        }
        try {
            return new ServerAddress(split[0], Integer.parseInt(split[1]));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MALFORMED_FORMAT_MSG);
        }
    }

    @Override
    public ServerAddress map(ServerAddress serverAddress) {
        ServerAddress transformed = this._mapping.get(serverAddress);
        if (transformed == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("No mapping exists for provided address " + serverAddress + " returning original address");
            }
            return serverAddress;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Mapping  address " + serverAddress + " to " + transformed);
        }
        return transformed;
    }
}

