/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.annotation.lrmi.AsyncRemoteCall;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.ConfigurationException;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.exception.lrmi.ProxyClosedException;
import com.gigaspaces.internal.lrmi.ConnectionUrlDescriptor;
import com.gigaspaces.internal.lrmi.LRMIOutboundMonitoringDetailsImpl;
import com.gigaspaces.internal.lrmi.LRMIProxyMonitoringDetailsImpl;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ProxyInvocationHandler;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.reflection.standard.StandardMethod;
import com.gigaspaces.internal.stubcache.StubId;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderCallable;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.lrmi.ClientPeerInvocationHandler;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIMethodMetadata;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.MethodCachedInvocationHandler;
import com.gigaspaces.lrmi.ObjectRegistry;
import com.gigaspaces.lrmi.RemoteMethodCache;
import com.gigaspaces.lrmi.ServerPeer;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import com.gigaspaces.lrmi.nio.async.IFuture;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.security.Security;

@InternalApi
public class DynamicSmartStub
implements ProxyInvocationHandler,
InvocationHandler,
Serializable,
Remote,
Externalizable,
ILRMIProxy {
    private static final long serialVersionUID = 1L;
    private static final byte SERIAL_VERSION = -128;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private transient Remote _localObj;
    private transient MethodCachedInvocationHandler _remoteInvHandler;
    private ITransportConfig _config;
    private String _connectionURL;
    private transient long _remoteProcessId;
    private transient InetSocketAddress _remoteNetworkAddress;
    private String _platformVersion;
    private int _hashCode;
    private long _remoteObjectId;
    private String _remoteObjClassName;
    private long _remoteClassLoaderId;
    private long _remoteLrmiRuntimeId;
    private boolean _unexported;
    private Map<String, Integer> _methodMapping;
    private transient Map<String, LRMIMethodMetadata> _methodsMetadata;
    private List<Class<?>> _stubInterfaces;
    private PlatformLogicalVersion _platformLogicalVersion;
    private transient Map<IMethod, IMethod> _identityMethodCache;
    private transient Map<String, IMethod> _methodDescTable;
    private static final Map<String, MethodCachedInvocationHandler> _remoteInvHandlerCache = new HashMap<String, MethodCachedInvocationHandler>();
    private static final String LRMI_PROXY_CLASS_NAME = ILRMIProxy.class.getName();
    private transient ClassLoader _exporterThreadContextClassLoader;
    private transient boolean _proxyClosed;
    public static final transient ThreadLocal<Boolean> markProxyAsClosed = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return true;
        }
    };

    public DynamicSmartStub() {
    }

    DynamicSmartStub(Remote localObj, ITransportConfig config) {
        this._exporterThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        this._localObj = localObj;
        this._config = config;
        this._remoteObjClassName = localObj.getClass().getName();
        this._stubInterfaces = LRMIUtilities.getDeclaredRemoteInterfaces(localObj.getClass());
        this._methodMapping = this.createMethodMapping();
        this._platformVersion = PlatformVersion.getOfficialVersion();
        this._platformLogicalVersion = PlatformLogicalVersion.getLogicalVersion();
        this.init();
        this._hashCode = this._remoteObjClassName.hashCode() ^ System.identityHashCode(localObj);
    }

    private Map<String, Integer> createMethodMapping() {
        List<IMethod> sortedMethodList = LRMIUtilities.getSortedMethodList(this._stubInterfaces);
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (int i = 0; i < sortedMethodList.size(); ++i) {
            mapping.put(LRMIUtilities.getMethodNameAndDescriptor(sortedMethodList.get(i)), i);
        }
        return mapping;
    }

    private synchronized void init() {
        this._identityMethodCache = Collections.synchronizedMap(new IdentityHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IMethod getReferenceMethod(IMethod dynamicProxyInvMethod) throws UnexpectedException {
        IMethod targetInkMethod = this._identityMethodCache.get(dynamicProxyInvMethod);
        if (targetInkMethod != null) {
            return targetInkMethod;
        }
        Map<IMethod, IMethod> map = this._identityMethodCache;
        synchronized (map) {
            String methodDesc;
            targetInkMethod = this._identityMethodCache.get(dynamicProxyInvMethod);
            if (targetInkMethod != null) {
                return targetInkMethod;
            }
            if (this._methodDescTable == null) {
                this._methodDescTable = LRMIUtilities.getMappingMethodDescriptor(this._localObj.getClass());
            }
            if ((targetInkMethod = this._methodDescTable.get(methodDesc = LRMIUtilities.getMethodNameAndDescriptor(dynamicProxyInvMethod))) == null) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "DynamicSmartStub - Failed to get method descriptor for  [" + dynamicProxyInvMethod + "] target class [" + this._localObj.getClass() + "].\nMethod signature: " + methodDesc);
                }
                throw new UnexpectedException("Method descriptor is not found for method: " + dynamicProxyInvMethod);
            }
            this._identityMethodCache.put(dynamicProxyInvMethod, targetInkMethod);
        }
        return targetInkMethod;
    }

    private static Object _invoke(Object targetObject, IMethod invokeMethod, Object[] args) throws Throwable {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.entering("DynamicSmartStub - " + targetObject.getClass().getName(), invokeMethod.getName(), args);
            }
            Object resultInv = invokeMethod.invoke(targetObject, args);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.exiting("DynamicSmartStub - " + targetObject.getClass().getName(), invokeMethod.getName(), resultInv);
            }
            return resultInv;
        }
        catch (InvocationTargetException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "DynamicSmartStub - Invoke method: [" + invokeMethod + "] on [" + targetObject.getClass() + "] thrown exception: " + e.toString());
            }
            throw e.getTargetException();
        }
        catch (IllegalArgumentException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "DynamicSmartStub - Failed to invoke method: [" + invokeMethod + "] on [" + targetObject.getClass() + "] thrown exception: " + e.toString() + "\nInvoke method ClassLoader: " + invokeMethod.getDeclaringClass().getClassLoader() + "\nTarget object instance ClassLoader: " + targetObject.getClass().getClassLoader());
            }
            throw e;
        }
        catch (IllegalAccessException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "DynamicSmartStub - Failed to invoke method: " + invokeMethod + ".\nMethod does not have an access to the definition of " + targetObject.getClass() + " class.");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object invokeDirect(final IMethod invokeMethod, Object[] args) throws Throwable {
        ClassLoader orgThreadCL = Thread.currentThread().getContextClassLoader();
        boolean changeCL = orgThreadCL != this._exporterThreadContextClassLoader;
        try {
            Object object;
            if (changeCL) {
                ClassLoaderHelper.setContextClassLoader(this._exporterThreadContextClassLoader, true);
            }
            if (invokeMethod.getDeclaringClass().isAssignableFrom(this._localObj.getClass())) {
                if (!invokeMethod.isAccessible()) {
                    Security.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            invokeMethod.setAccessible(true);
                            return null;
                        }
                    });
                }
                Object object2 = DynamicSmartStub._invoke(this._localObj, invokeMethod, args);
                return object2;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("DynamicSmartStub - declared ClassLoader of invoke method is not is assignable from ClassLoader of localObject. Converting method arguments to ClassLoader of localObject.\nMethod: " + invokeMethod + "\nDeclared Method ClassLoader: " + invokeMethod.getDeclaringClass().getClassLoader() + "\nLocalObject ClassLoader: " + this._localObj.getClass().getClassLoader() + "\nExported ThreadClassLoader: " + this._exporterThreadContextClassLoader);
            }
            final IMethod refMethod = this.getReferenceMethod(invokeMethod);
            final Object[] clArgs = (Object[])LRMIUtilities.convertToAssignableClassLoader(args, this._localObj.getClass().getClassLoader());
            boolean async = refMethod.getAnnotation(AsyncRemoteCall.class) != null;
            Object returnValue = null;
            if (async) {
                Future<Object> future = LRMIRuntime.getRuntime().getThreadPool().submit(new ContextClassLoaderCallable<Object>(){

                    @Override
                    protected Object execute() throws Exception {
                        try {
                            return DynamicSmartStub._invoke(DynamicSmartStub.this._localObj, refMethod, clArgs);
                        }
                        catch (Throwable t) {
                            throw new ExecutionException(t);
                        }
                    }
                });
                FutureContext.setFutureResult((IFuture)future);
            } else {
                returnValue = DynamicSmartStub._invoke(this._localObj, refMethod, clArgs);
            }
            if (returnValue == null) {
                object = null;
                return object;
            }
            object = LRMIUtilities.convertToAssignableClassLoader(returnValue, invokeMethod.getDeclaringClass().getClassLoader());
            return object;
        }
        finally {
            if (changeCL) {
                ClassLoaderHelper.setContextClassLoader(orgThreadCL, true);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invoke(proxy, new StandardMethod(method), args);
    }

    @Override
    public Object invoke(Object proxy, IMethod method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                return this.equals(args[0]);
            }
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            throw new InternalError("Unexpected Object method dispatched: " + method);
        }
        if (LRMI_PROXY_CLASS_NAME.equals(declaringClass.getName())) {
            return this.invokeLRMIProxy(method, args);
        }
        if (this._localObj == null) {
            return this.invokeRemote(proxy, method, args);
        }
        return this.invokeDirect(method, args);
    }

    private Object invokeLRMIProxy(IMethod method, Object[] args) throws Exception {
        return method.invoke(this, args);
    }

    protected Object invokeRemote(Object proxy, IMethod method, Object[] args) throws Throwable {
        MethodCachedInvocationHandler remoteInvocationHandler = this.getInvocationHandler();
        return remoteInvocationHandler.invoke(proxy, method, args);
    }

    private MethodCachedInvocationHandler getExistingInvocationHandler() {
        return this._remoteInvHandler;
    }

    protected MethodCachedInvocationHandler getInvocationHandler() throws RemoteException {
        MethodCachedInvocationHandler existingHandler = this.getExistingInvocationHandler();
        if (existingHandler != null) {
            return existingHandler;
        }
        Map<String, MethodCachedInvocationHandler> map = _remoteInvHandlerCache;
        synchronized (map) {
            if (this._proxyClosed) {
                DynamicSmartStub.throwProxyClosedExeption(this._connectionURL);
            }
            if ((existingHandler = this.getExistingInvocationHandler()) != null) {
                return existingHandler;
            }
            MethodCachedInvocationHandler peerInvocationHandler = _remoteInvHandlerCache.get(this._connectionURL);
            if (peerInvocationHandler != null) {
                peerInvocationHandler.incrementReference();
                this._remoteInvHandler = peerInvocationHandler;
                return this._remoteInvHandler;
            }
            try {
                ClientPeerInvocationHandler clientInvocationHandler = LRMIRuntime.getRuntime().getClientInvocationHandler(this._connectionURL, this._config, this._platformLogicalVersion);
                RemoteMethodCache methodCache = LRMIUtilities.createRemoteMethodCache(this._stubInterfaces, this._methodMapping, this._methodsMetadata);
                this._remoteInvHandler = new MethodCachedInvocationHandler(methodCache, clientInvocationHandler, this._platformVersion, this._platformLogicalVersion, this._connectionURL);
                _remoteInvHandlerCache.put(this._connectionURL, this._remoteInvHandler);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(Thread.currentThread() + " DynamicSmartStub prepared connection: " + this.toString());
                }
                return this._remoteInvHandler;
            }
            catch (ProxyClosedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RemoteException("Failed to initialize client connection." + this.toString(), ex);
            }
        }
    }

    public long getRemoteObjID() {
        return this._remoteObjectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this._localObj != null) {
            DynamicSmartStub dynamicSmartStub = this;
            synchronized (dynamicSmartStub) {
                if (this._connectionURL == null) {
                    ClassLoader orgCL = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this._exporterThreadContextClassLoader);
                        ServerPeer sp = LRMIRuntime.getRuntime().export(this._localObj, this._config);
                        this._remoteObjectId = sp.getObjectId();
                        this._remoteClassLoaderId = sp.getObjectClassLoaderId();
                        this._remoteLrmiRuntimeId = LRMIRuntime.getRuntime().getID();
                        try {
                            this._connectionURL = sp.getConnectionURL();
                        }
                        catch (NullPointerException e) {
                            _logger.log(Level.SEVERE, "DEBUG: config is " + this._config);
                            throw e;
                        }
                    }
                    catch (ConfigurationException ex) {
                        throw new RemoteException("Failed to export object: " + this._remoteObjClassName, ex);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(orgCL);
                    }
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.finer("Exported and bound ServerEndPoint: " + this.toString());
                    }
                }
            }
        }
        out.writeByte(-128);
        out.writeObject(this._platformLogicalVersion);
        out.writeUTF(this._platformVersion);
        out.writeObject(this._config);
        out.writeUTF(this._connectionURL);
        out.writeInt(this._hashCode);
        out.writeLong(this._remoteObjectId);
        out.writeLong(this._remoteClassLoaderId);
        out.writeLong(this._remoteLrmiRuntimeId);
        out.writeUTF(this._remoteObjClassName);
        out.writeObject(this._methodMapping);
        out.writeObject(this.filter(this._stubInterfaces));
        out.writeBoolean(this._unexported);
    }

    private List<Class<?>> filter(List<Class<?>> interfaces) {
        PlatformLogicalVersion platformLogicalVersion = LRMIInvocationContext.getEndpointLogicalVersion();
        ArrayList res = new ArrayList();
        for (Class<?> anInterface : interfaces) {
            if (anInterface.getName().equals("com.gigaspaces.internal.cluster.node.impl.router.CallbackVerifier") && platformLogicalVersion.lessThan(PlatformLogicalVersion.v12_0_1)) continue;
            res.add(anInterface);
        }
        return res;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ObjectRegistry.Entry objectEntry;
        byte version = in.readByte();
        if (version != -128) {
            throw new UnmarshalException("Requested version [" + version + "] does not match local version [" + -128 + "]. Please make sure you are using the same version on both ends, local version is " + PlatformVersion.getOfficialVersion());
        }
        this._platformLogicalVersion = (PlatformLogicalVersion)in.readObject();
        this._platformVersion = in.readUTF();
        this._config = (ITransportConfig)in.readObject();
        this._connectionURL = in.readUTF();
        ConnectionUrlDescriptor connectionUrlDescriptor = ConnectionUrlDescriptor.fromUrl(this._connectionURL);
        this._remoteNetworkAddress = connectionUrlDescriptor.getSocketAddress();
        this._remoteProcessId = connectionUrlDescriptor.getPid();
        this._hashCode = in.readInt();
        this._remoteObjectId = in.readLong();
        this._remoteClassLoaderId = in.readLong();
        this._remoteLrmiRuntimeId = in.readLong();
        this._remoteObjClassName = in.readUTF();
        this._methodMapping = (Map)in.readObject();
        this._stubInterfaces = (List)in.readObject();
        this._unexported = in.readBoolean();
        this.init();
        if (this._localObj == null && !LRMIRuntime.getRuntime().isUseNetworkInJVM() && (objectEntry = LRMIRuntime.getRuntime().getRegistryObject(this._remoteObjectId)) != null) {
            this._localObj = objectEntry.getObject();
            this._exporterThreadContextClassLoader = objectEntry.getExportedThreadClassLoader();
        }
    }

    public Object getLocalObjImpl() {
        return this._localObj;
    }

    public static DynamicSmartStub extractDynamicSmartStubFrom(Object obj) {
        DynamicSmartStub dynStub = null;
        if (ReflectionUtil.isProxyClass(obj.getClass())) {
            Object ih = ReflectionUtil.getInvocationHandler(obj);
            if (ih instanceof DynamicSmartStub) {
                dynStub = (DynamicSmartStub)ih;
            }
        } else if (obj instanceof DynamicSmartStub) {
            dynStub = (DynamicSmartStub)obj;
        }
        return dynStub;
    }

    public boolean isCollocated() {
        return this._localObj != null;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DynamicSmartStub eqSt = DynamicSmartStub.extractDynamicSmartStubFrom(obj);
        if (eqSt == null) {
            return false;
        }
        if (eqSt == this) {
            return true;
        }
        if (this._localObj != null && eqSt.getLocalObjImpl() != null) {
            return this._localObj == eqSt.getLocalObjImpl();
        }
        return this._remoteObjectId == eqSt._remoteObjectId;
    }

    public synchronized boolean isUnexported() {
        return this._unexported;
    }

    synchronized void unexport() {
        block6: {
            if (this._unexported) {
                return;
            }
            this._unexported = true;
            try {
                if (this._connectionURL != null) {
                    LRMIRuntime.getRuntime().unexport(this._localObj, this._config.getProtocolName(), true);
                }
            }
            catch (NoSuchObjectException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("RemoteObject: [" + this._localObj.getClass().getName() + "] was never exported.");
                }
            }
            catch (RemoteException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block6;
                _logger.log(Level.SEVERE, "Failed to unexport " + this._localObj.getClass().getName() + " object.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeProxy() {
        if (this._proxyClosed) {
            return;
        }
        Map<String, MethodCachedInvocationHandler> map = _remoteInvHandlerCache;
        synchronized (map) {
            if (this._proxyClosed) {
                return;
            }
            MethodCachedInvocationHandler existingInvocationHandler = this.getExistingInvocationHandler();
            if (existingInvocationHandler != null && existingInvocationHandler.decrementReference()) {
                _remoteInvHandlerCache.remove(this._connectionURL);
            }
            this._remoteInvHandler = null;
            if (markProxyAsClosed == null || markProxyAsClosed.get().booleanValue()) {
                this._proxyClosed = true;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._proxyClosed;
    }

    @Override
    public boolean isRemote() {
        return this._localObj == null;
    }

    @Override
    public PlatformLogicalVersion getServicePlatformLogicalVersion() {
        return this._platformLogicalVersion;
    }

    @Override
    public long getGeneratedTraffic() {
        MethodCachedInvocationHandler remoteInvHandler = this._remoteInvHandler;
        if (remoteInvHandler == null) {
            return 0L;
        }
        return remoteInvHandler.getInvocationHandler().getGeneratedTraffic();
    }

    @Override
    public long getReceivedTraffic() {
        MethodCachedInvocationHandler remoteInvHandler = this._remoteInvHandler;
        if (remoteInvHandler == null) {
            return 0L;
        }
        return remoteInvHandler.getInvocationHandler().getReceivedTraffic();
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionURL;
    }

    @Override
    public long getRemoteProcessId() {
        return this._remoteProcessId;
    }

    @Override
    public String getRemoteHostName() {
        return this._remoteNetworkAddress != null ? this._remoteNetworkAddress.getHostName() : null;
    }

    @Override
    public String getRemoteHostAddress() {
        return this._remoteNetworkAddress != null ? this._remoteNetworkAddress.getAddress().getHostAddress() : null;
    }

    @Override
    public InetSocketAddress getRemoteNetworkAddress() {
        return this._remoteNetworkAddress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DynamicSmartStub [ImplObjClass: " + this._remoteObjClassName);
        if (this._localObj != null) {
            sb.append(", RemoteObjRef: Still in local VM");
            sb.append(", ObjectClassLoader: " + this._localObj.getClass().getClassLoader());
            sb.append(", ExportedThreadClassLoader: " + this._exporterThreadContextClassLoader);
        }
        if (this._connectionURL != null) {
            sb.append(", ConnectionURL: " + this._connectionURL);
        }
        sb.append(", MaxConnPool: " + this._config.getConnectionPoolSize());
        if (this._localObj != null) {
            sb.append(", localImpl toString: [" + this._localObj.toString() + "]");
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public StubId getStubId() {
        return new StubId(this._remoteLrmiRuntimeId, this._remoteObjectId);
    }

    @Override
    public void disable() throws RemoteException {
        this.getInvocationHandler().disable();
    }

    @Override
    public void enable() throws RemoteException {
        this.getInvocationHandler().enable();
    }

    @Override
    public synchronized void overrideMethodsMetadata(Map<String, LRMIMethodMetadata> methodsMetadata) {
        this._methodsMetadata = methodsMetadata;
    }

    public static void throwProxyClosedExeption(String connectionUrl) throws ProxyClosedException {
        throw new ProxyClosedException("proxy is closed [" + connectionUrl + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LRMIOutboundMonitoringDetailsImpl getMonitoringDetails() {
        LinkedList<LRMIProxyMonitoringDetailsImpl> lrmiProxyMonitoringDetails = new LinkedList<LRMIProxyMonitoringDetailsImpl>();
        Map<String, MethodCachedInvocationHandler> map = _remoteInvHandlerCache;
        synchronized (map) {
            for (MethodCachedInvocationHandler invocationHandler : _remoteInvHandlerCache.values()) {
                lrmiProxyMonitoringDetails.add(invocationHandler.getMonitoringDetails());
            }
            return new LRMIOutboundMonitoringDetailsImpl(lrmiProxyMonitoringDetails.toArray(new LRMIProxyMonitoringDetailsImpl[lrmiProxyMonitoringDetails.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdown() {
        Map<String, MethodCachedInvocationHandler> map = _remoteInvHandlerCache;
        synchronized (map) {
            for (MethodCachedInvocationHandler cachedHandler : _remoteInvHandlerCache.values()) {
                cachedHandler.getInvocationHandler().close();
            }
            _remoteInvHandlerCache.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.closeProxy();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulatedDisconnectionByPID(int pid) {
        Map<String, MethodCachedInvocationHandler> map = _remoteInvHandlerCache;
        synchronized (map) {
            String pidToken = "pid[" + pid + "]";
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("disabling outbound LRMI stubs to pid [ " + pid + " ] my pid is [ " + SystemInfo.singleton().os().processId() + " ]");
            }
            for (MethodCachedInvocationHandler invocationHandler : _remoteInvHandlerCache.values()) {
                if (!invocationHandler.getConnectionURL().contains(pidToken)) continue;
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.info("disabling stub [ " + invocationHandler.getConnectionURL() + " ]");
                }
                invocationHandler.disable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulatedReconnectionByPID(int pid) {
        Map<String, MethodCachedInvocationHandler> map = _remoteInvHandlerCache;
        synchronized (map) {
            String pidToken = "pid[" + pid + "]";
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("enabling outbound LRMI stubs to pid [ " + pid + " ] my pid is [ " + SystemInfo.singleton().os().processId() + " ]");
            }
            for (MethodCachedInvocationHandler invocationHandler : _remoteInvHandlerCache.values()) {
                if (!invocationHandler.getConnectionURL().contains(pidToken)) continue;
                _logger.log(Level.INFO, "enabling stub [ " + invocationHandler.getConnectionURL() + " ]");
                invocationHandler.enable();
            }
        }
    }
}

