/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.lrmi.DynamicSmartStub;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.TransportProtocolHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.Exporter;

@InternalApi
public class GenericExporter
implements Exporter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.exporter");
    private final ITransportConfig _config;
    private transient Map<WeakKey, WeakReference<Remote>> _identityExportObjTable = new HashMap<WeakKey, WeakReference<Remote>>();

    public GenericExporter(ITransportConfig config) {
        this._config = config;
    }

    public ITransportConfig getConfiguration() {
        return this._config;
    }

    public synchronized Remote export(Remote impl) throws ExportException {
        return this.export(impl, this._config, true);
    }

    public synchronized Remote export(Remote impl, boolean allowCache) throws ExportException {
        return this.export(impl, this._config, allowCache);
    }

    public synchronized Remote export(Remote impl, ITransportConfig config, boolean allowCache) throws ExportException {
        Remote implStub;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Trying to export class=" + impl.getClass());
        }
        if (impl == null) {
            throw new IllegalArgumentException("Remote obj can not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Configuration object can not be null");
        }
        WeakKey wk = new WeakKey(impl);
        WeakReference<Remote> value = this._identityExportObjTable.get(wk);
        Remote remote = implStub = value != null ? (Remote)value.get() : null;
        if (implStub != null) {
            return implStub;
        }
        implStub = LRMIRuntime.getRuntime().createDynamicProxy(impl, config, allowCache);
        this._identityExportObjTable.put(wk, new WeakReference<Remote>(implStub));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ObjImpl: [" + implStub + "] was exported.");
        }
        return implStub;
    }

    protected synchronized boolean _unexport(Remote obj) {
        Remote dynamicProxy;
        WeakReference<Remote> weakStub = this._identityExportObjTable.get(new WeakKey(obj));
        Remote remote = dynamicProxy = weakStub != null ? (Remote)weakStub.get() : null;
        if (dynamicProxy == null) {
            return true;
        }
        DynamicSmartStub dynamicSmartStub = TransportProtocolHelper.extractSmartStubFromProxy(dynamicProxy);
        dynamicSmartStub.unexport();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ObjImpl: [" + dynamicSmartStub.getLocalObjImpl() + "] was unexported.");
        }
        return true;
    }

    public synchronized boolean unexport(Remote obj) {
        this._unexport(obj);
        this._identityExportObjTable.remove(new WeakKey(obj));
        return true;
    }

    public synchronized boolean unexport(boolean force) {
        Iterator<WeakKey> iter = this._identityExportObjTable.keySet().iterator();
        while (iter.hasNext()) {
            WeakKey exportedObjImpl = iter.next();
            Remote obj = (Remote)exportedObjImpl.get();
            if (obj != null) {
                this._unexport(obj);
            }
            iter.remove();
        }
        return true;
    }

    public synchronized boolean isExported(Remote obj) {
        return this._identityExportObjTable.containsKey(new WeakKey(obj));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._identityExportObjTable = new HashMap<WeakKey, WeakReference<Remote>>();
    }

    private static class WeakKey
    extends WeakReference<Remote> {
        private int hashCode;
        private String className;

        public WeakKey(Remote obj) {
            super(obj);
            if (obj == null) {
                throw new IllegalArgumentException("The Key can't be null");
            }
            this.className = obj.getClass().getName();
            this.hashCode = obj.getClass().hashCode() ^ System.identityHashCode(obj);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakKey)) {
                return false;
            }
            WeakKey weakKey = (WeakKey)o;
            Object key = weakKey.get();
            return key == this.get();
        }

        public String toString() {
            Object implObj = this.get();
            if (implObj == null) {
                return "ImplObj: [Collected by GC-" + this.className + "@" + this.hashCode;
            }
            return "ImplObj: [" + this.className + "@" + this.hashCode;
        }
    }
}

